"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetManifestArtifact = void 0;
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
/**
 * (experimental) Asset manifest is a description of a set of assets which need to be built and published.
 *
 * @experimental
 */
class AssetManifestArtifact extends cloud_artifact_1.CloudArtifact {
    /**
     * @experimental
     */
    constructor(assembly, name, artifact) {
        var _a;
        super(assembly, name, artifact);
        const properties = (this.manifest.properties || {});
        if (!properties.file) {
            throw new Error('Invalid AssetManifestArtifact. Missing "file" property');
        }
        this.file = path.resolve(this.assembly.directory, properties.file);
        this.requiresBootstrapStackVersion = (_a = properties.requiresBootstrapStackVersion) !== null && _a !== void 0 ? _a : 1;
    }
}
exports.AssetManifestArtifact = AssetManifestArtifact;
//# sourceMappingURL=data:application/json;base64,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