"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BUNDLING_STACKS = exports.DISABLE_METADATA_STACK_TRACE = exports.DISABLE_ASSET_STAGING_CONTEXT = exports.ANALYTICS_REPORTING_ENABLED_CONTEXT = exports.PATH_METADATA_ENABLE_CONTEXT = void 0;
// --------------------------------------------------------------------------------
// This file declares context keys that are used by the CLI to control the
// behavior of CDK apps. Contrary to feature flags (which are defined under
// `features.ts`) these options are not bound to be removed in the next major
// version.
// --------------------------------------------------------------------------------
/**
 * Enables the embedding of the "aws:cdk:path" in CloudFormation template metadata.
 */
exports.PATH_METADATA_ENABLE_CONTEXT = 'aws:cdk:enable-path-metadata';
/**
 * Enable the collection and reporting of version information.
 */
exports.ANALYTICS_REPORTING_ENABLED_CONTEXT = 'aws:cdk:version-reporting';
/**
 * Disable asset staging (for use with SAM CLI).
 *
 * Disabling asset staging means that copyable assets will not be copied to the
 * output directory and will be referenced with absolute paths.
 *
 * Not copied to the output directory: this is so users can iterate on the
 * Lambda source and run SAM CLI without having to re-run CDK (note: we
 * cannot achieve this for bundled assets, if assets are bundled they
 * will have to re-run CDK CLI to re-bundle updated versions).
 *
 * Absolute path: SAM CLI expects `cwd`-relative paths in a resource's
 * `aws:asset:path` metadata. In order to be predictable, we will always output
 * absolute paths.
 */
exports.DISABLE_ASSET_STAGING_CONTEXT = 'aws:cdk:disable-asset-staging';
/**
 * If this context key is set, the CDK will stage assets under the specified
 * directory. Otherwise, assets will not be staged.
 * Omits stack traces from construct metadata entries.
 */
exports.DISABLE_METADATA_STACK_TRACE = 'aws:cdk:disable-stack-trace';
/**
 * Run bundling for stacks specified in this context key
 */
exports.BUNDLING_STACKS = 'aws:cdk:bundling-stacks';
//# sourceMappingURL=data:application/json;base64,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