import { IAspect } from './aspect';
import { Construct, IConstruct } from './construct-compat';
import { ITaggable } from './tag-manager';
/**
 * (experimental) Properties for a tag.
 *
 * @experimental
 */
export interface TagProps {
    /**
     * (experimental) Whether the tag should be applied to instances in an AutoScalingGroup.
     *
     * @default true
     * @experimental
     */
    readonly applyToLaunchedInstances?: boolean;
    /**
     * (experimental) An array of Resource Types that will not receive this tag.
     *
     * An empty array will allow this tag to be applied to all resources. A
     * non-empty array will apply this tag only if the Resource type is not in
     * this array.
     *
     * @default []
     * @experimental
     */
    readonly excludeResourceTypes?: string[];
    /**
     * (experimental) An array of Resource Types that will receive this tag.
     *
     * An empty array will match any Resource. A non-empty array will apply this
     * tag only to Resource types that are included in this array.
     *
     * @default []
     * @experimental
     */
    readonly includeResourceTypes?: string[];
    /**
     * (experimental) Priority of the tag operation.
     *
     * Higher or equal priority tags will take precedence.
     *
     * Setting priority will enable the user to control tags when they need to not
     * follow the default precedence pattern of last applied and closest to the
     * construct in the tree.
     *
     * @default Default priorities:
     *
     * - 100 for {@link SetTag}
     * - 200 for {@link RemoveTag}
     * - 50 for tags added directly to CloudFormation resources
     * @experimental
     */
    readonly priority?: number;
}
/**
 * The common functionality for Tag and Remove Tag Aspects
 */
declare abstract class TagBase implements IAspect {
    /**
     * (experimental) The string key for the tag.
     *
     * @experimental
     */
    readonly key: string;
    /**
     * @experimental
     */
    protected readonly props: TagProps;
    constructor(key: string, props?: TagProps);
    /**
     * (experimental) All aspects can visit an IConstruct.
     *
     * @experimental
     */
    visit(construct: IConstruct): void;
    protected abstract applyTag(resource: ITaggable): void;
}
/**
 * (experimental) The Tag Aspect will handle adding a tag to this node and cascading tags to children.
 *
 * @experimental
 */
export declare class Tag extends TagBase {
    /**
     * (deprecated) DEPRECATED: add tags to the node of a construct and all its the taggable children.
     *
     * @deprecated use `Tags.of(scope).add()`
     */
    static add(scope: Construct, key: string, value: string, props?: TagProps): void;
    /**
     * (deprecated) DEPRECATED: remove tags to the node of a construct and all its the taggable children.
     *
     * @deprecated use `Tags.of(scope).remove()`
     */
    static remove(scope: Construct, key: string, props?: TagProps): void;
    /**
     * (experimental) The string value of the tag.
     *
     * @experimental
     */
    readonly value: string;
    private readonly defaultPriority;
    /**
     * @experimental
     */
    constructor(key: string, value: string, props?: TagProps);
    /**
     * @experimental
     */
    protected applyTag(resource: ITaggable): void;
}
/**
 * (experimental) Manages AWS tags for all resources within a construct scope.
 *
 * @experimental
 */
export declare class Tags {
    private readonly scope;
    /**
     * (experimental) Returns the tags API for this scope.
     *
     * @param scope The scope.
     * @experimental
     */
    static of(scope: IConstruct): Tags;
    private constructor();
    /**
     * (experimental) add tags to the node of a construct and all its the taggable children.
     *
     * @experimental
     */
    add(key: string, value: string, props?: TagProps): void;
    /**
     * (experimental) remove tags to the node of a construct and all its the taggable children.
     *
     * @experimental
     */
    remove(key: string, props?: TagProps): void;
}
/**
 * (experimental) The RemoveTag Aspect will handle removing tags from this node and children.
 *
 * @experimental
 */
export declare class RemoveTag extends TagBase {
    private readonly defaultPriority;
    /**
     * @experimental
     */
    constructor(key: string, props?: TagProps);
    /**
     * @experimental
     */
    protected applyTag(resource: ITaggable): void;
}
export {};
