import { DockerImageAssetLocation, DockerImageAssetSource, FileAssetLocation, FileAssetSource } from '../assets';
import { ISynthesisSession } from '../construct-compat';
import { DefaultStackSynthesizer } from './default-synthesizer';
/**
 * (experimental) Construction properties of {@link BootstraplessSynthesizer}.
 *
 * @experimental
 */
export interface BootstraplessSynthesizerProps {
    /**
     * (experimental) The deploy Role ARN to use.
     *
     * @default - No deploy role (use CLI credentials)
     * @experimental
     */
    readonly deployRoleArn?: string;
    /**
     * (experimental) The CFN execution Role ARN to use.
     *
     * @default - No CloudFormation role (use CLI credentials)
     * @experimental
     */
    readonly cloudFormationExecutionRoleArn?: string;
}
/**
 * (experimental) A special synthesizer that behaves similarly to DefaultStackSynthesizer, but doesn't require bootstrapping the environment it operates in.
 *
 * Because of that, stacks using it cannot have assets inside of them.
 * Used by the CodePipeline construct for the support stacks needed for
 * cross-region replication S3 buckets.
 *
 * @experimental
 */
export declare class BootstraplessSynthesizer extends DefaultStackSynthesizer {
    /**
     * @experimental
     */
    constructor(props: BootstraplessSynthesizerProps);
    /**
     * (experimental) Register a File Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     *
     * @experimental
     */
    addFileAsset(_asset: FileAssetSource): FileAssetLocation;
    /**
     * (experimental) Register a Docker Image Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     *
     * @experimental
     */
    addDockerImageAsset(_asset: DockerImageAssetSource): DockerImageAssetLocation;
    /**
     * (experimental) Synthesize the associated stack to the session.
     *
     * @experimental
     */
    synthesize(session: ISynthesisSession): void;
}
