import { IConstruct, Construct as CoreConstruct } from './construct-compat';
import { Construct } from 'constructs';
import { ArnComponents } from './arn';
import { Stack } from './stack';
/**
 * (experimental) Represents the environment a given resource lives in.
 *
 * Used as the return value for the {@link IResource.env} property.
 *
 * @experimental
 */
export interface ResourceEnvironment {
    /**
     * (experimental) The AWS account ID that this resource belongs to.
     *
     * Since this can be a Token
     * (for example, when the account is CloudFormation's AWS::AccountId intrinsic),
     * make sure to use Token.compareStrings()
     * instead of just comparing the values for equality.
     *
     * @experimental
     */
    readonly account: string;
    /**
     * (experimental) The AWS region that this resource belongs to.
     *
     * Since this can be a Token
     * (for example, when the region is CloudFormation's AWS::Region intrinsic),
     * make sure to use Token.compareStrings()
     * instead of just comparing the values for equality.
     *
     * @experimental
     */
    readonly region: string;
}
/**
 * (experimental) Interface for the Resource construct.
 *
 * @experimental
 */
export interface IResource extends IConstruct {
    /**
     * (experimental) The stack in which this resource is defined.
     *
     * @experimental
     */
    readonly stack: Stack;
    /**
     * (experimental) The environment this resource belongs to.
     *
     * For resources that are created and managed by the CDK
     * (generally, those created by creating new class instances like Role, Bucket, etc.),
     * this is always the same as the environment of the stack they belong to;
     * however, for imported resources
     * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
     * that might be different than the stack they were imported into.
     *
     * @experimental
     */
    readonly env: ResourceEnvironment;
}
/**
 * (experimental) Construction properties for {@link Resource}.
 *
 * @experimental
 */
export interface ResourceProps {
    /**
     * (experimental) The value passed in by users to the physical name prop of the resource.
     *
     * - `undefined` implies that a physical name will be allocated by
     *    CloudFormation during deployment.
     * - a concrete value implies a specific physical name
     * - `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
     *    by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.
     *
     * @default - The physical name will be allocated by CloudFormation at deployment time
     * @experimental
     */
    readonly physicalName?: string;
    /**
     * (experimental) The AWS account ID this resource belongs to.
     *
     * @default - the resource is in the same account as the stack it belongs to
     * @experimental
     */
    readonly account?: string;
    /**
     * (experimental) The AWS region this resource belongs to.
     *
     * @default - the resource is in the same region as the stack it belongs to
     * @experimental
     */
    readonly region?: string;
}
/**
 * (experimental) A construct which represents an AWS resource.
 *
 * @experimental
 */
export declare abstract class Resource extends CoreConstruct implements IResource {
    /**
     * (experimental) The stack in which this resource is defined.
     *
     * @experimental
     */
    readonly stack: Stack;
    /**
     * (experimental) The environment this resource belongs to.
     *
     * For resources that are created and managed by the CDK
     * (generally, those created by creating new class instances like Role, Bucket, etc.),
     * this is always the same as the environment of the stack they belong to;
     * however, for imported resources
     * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
     * that might be different than the stack they were imported into.
     *
     * @experimental
     */
    readonly env: ResourceEnvironment;
    /**
     * (experimental) Returns a string-encoded token that resolves to the physical name that should be passed to the CloudFormation resource.
     *
     * This value will resolve to one of the following:
     * - a concrete value (e.g. `"my-awesome-bucket"`)
     * - `undefined`, when a name should be generated by CloudFormation
     * - a concrete name generated automatically during synthesis, in
     *    cross-environment scenarios.
     *
     * @experimental
     */
    protected readonly physicalName: string;
    private _physicalName;
    private readonly _allowCrossEnvironment;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ResourceProps);
    /**
     * Called when this resource is referenced across environments
     * (account/region) to order to request that a physical name will be generated
     * for this resource during synthesis, so the resource can be referenced
     * through it's absolute name/arn.
     *
     * @internal
     */
    _enableCrossEnvironment(): void;
    /**
     * @experimental
     */
    protected generatePhysicalName(): string;
    /**
     * (experimental) Returns an environment-sensitive token that should be used for the resource's "name" attribute (e.g. `bucket.bucketName`).
     *
     * Normally, this token will resolve to `nameAttr`, but if the resource is
     * referenced across environments, it will be resolved to `this.physicalName`,
     * which will be a concrete name.
     *
     * @param nameAttr The CFN attribute which resolves to the resource's name.
     * @experimental
     */
    protected getResourceNameAttribute(nameAttr: string): string;
    /**
     * (experimental) Returns an environment-sensitive token that should be used for the resource's "ARN" attribute (e.g. `bucket.bucketArn`).
     *
     * Normally, this token will resolve to `arnAttr`, but if the resource is
     * referenced across environments, `arnComponents` will be used to synthesize
     * a concrete ARN with the resource's physical name. Make sure to reference
     * `this.physicalName` in `arnComponents`.
     *
     * @param arnAttr The CFN attribute which resolves to the ARN of the resource.
     * @param arnComponents The format of the ARN of this resource.
     * @experimental
     */
    protected getResourceArnAttribute(arnAttr: string, arnComponents: ArnComponents): string;
}
