import { Construct } from 'constructs';
import { ConstructNode } from './construct-compat';
/**
 * (experimental) Functions for devising unique names for constructs.
 *
 * For example, those can be
 * used to allocate unique physical names for resources.
 *
 * @experimental
 */
export declare class Names {
    /**
     * (experimental) Returns a CloudFormation-compatible unique identifier for a construct based on its path.
     *
     * The identifier includes a human readable porition rendered
     * from the path components and a hash suffix.
     *
     * @param construct The construct.
     * @returns a unique id based on the construct path
     * @experimental
     */
    static uniqueId(construct: Construct): string;
    /**
     * (experimental) Returns a CloudFormation-compatible unique identifier for a construct based on its path.
     *
     * The identifier includes a human readable porition rendered
     * from the path components and a hash suffix.
     *
     * TODO (v2): replace with API to use `constructs.Node`.
     *
     * @param node The construct node.
     * @returns a unique id based on the construct path
     * @experimental
     */
    static nodeUniqueId(node: ConstructNode): string;
    private constructor();
}
