import { IResolvable, IResolveContext } from './resolvable';
/**
 * (experimental) Interface for lazy string producers.
 *
 * @experimental
 */
export interface IStringProducer {
    /**
     * (experimental) Produce the string value.
     *
     * @experimental
     */
    produce(context: IResolveContext): string | undefined;
}
/**
 * (experimental) Interface for lazy list producers.
 *
 * @experimental
 */
export interface IListProducer {
    /**
     * (experimental) Produce the list value.
     *
     * @experimental
     */
    produce(context: IResolveContext): string[] | undefined;
}
/**
 * (experimental) Interface for lazy number producers.
 *
 * @experimental
 */
export interface INumberProducer {
    /**
     * (experimental) Produce the number value.
     *
     * @experimental
     */
    produce(context: IResolveContext): number | undefined;
}
/**
 * (experimental) Interface for lazy untyped value producers.
 *
 * @experimental
 */
export interface IAnyProducer {
    /**
     * (experimental) Produce the value.
     *
     * @experimental
     */
    produce(context: IResolveContext): any;
}
/**
 * (experimental) Options for creating a lazy string token.
 *
 * @experimental
 */
export interface LazyStringValueOptions {
    /**
     * (experimental) Use the given name as a display hint.
     *
     * @default - No hint
     * @experimental
     */
    readonly displayHint?: string;
}
/**
 * (experimental) Options for creating a lazy list token.
 *
 * @experimental
 */
export interface LazyListValueOptions {
    /**
     * (experimental) Use the given name as a display hint.
     *
     * @default - No hint
     * @experimental
     */
    readonly displayHint?: string;
    /**
     * (experimental) If the produced list is empty, return 'undefined' instead.
     *
     * @default false
     * @experimental
     */
    readonly omitEmpty?: boolean;
}
/**
 * (experimental) Options for creating lazy untyped tokens.
 *
 * @experimental
 */
export interface LazyAnyValueOptions {
    /**
     * (experimental) Use the given name as a display hint.
     *
     * @default - No hint
     * @experimental
     */
    readonly displayHint?: string;
    /**
     * (experimental) If the produced value is an array and it is empty, return 'undefined' instead.
     *
     * @default false
     * @experimental
     */
    readonly omitEmptyArray?: boolean;
}
/**
 * (experimental) Lazily produce a value.
 *
 * Can be used to return a string, list or numeric value whose actual value
 * will only be calculated later, during synthesis.
 *
 * @experimental
 */
export declare class Lazy {
    /**
     * @experimental
     */
    static stringValue(producer: IStringProducer, options?: LazyStringValueOptions): string;
    /**
     * @experimental
     */
    static numberValue(producer: INumberProducer): number;
    /**
     * @experimental
     */
    static listValue(producer: IListProducer, options?: LazyListValueOptions): string[];
    /**
     * @experimental
     */
    static anyValue(producer: IAnyProducer, options?: LazyAnyValueOptions): IResolvable;
    private constructor();
}
