/**
 * (experimental) Determines how symlinks are followed.
 *
 * @experimental
 */
export declare enum SymlinkFollowMode {
    /**
     * (experimental) Never follow symlinks.
     *
     * @experimental
     */
    NEVER = "never",
    /**
     * (experimental) Materialize all symlinks, whether they are internal or external to the source directory.
     *
     * @experimental
     */
    ALWAYS = "always",
    /**
     * (experimental) Only follows symlinks that are external to the source directory.
     *
     * @experimental
     */
    EXTERNAL = "external",
    /**
     * (experimental) Forbids source from having any symlinks pointing outside of the source tree.
     *
     * This is the safest mode of operation as it ensures that copy operations
     * won't materialize files from the user's file system. Internal symlinks are
     * not followed.
     *
     * If the copy operation runs into an external symlink, it will fail.
     *
     * @experimental
     */
    BLOCK_EXTERNAL = "internal-only"
}
/**
 * (experimental) Obtains applied when copying directories into the staging location.
 *
 * @experimental
 */
export interface CopyOptions {
    /**
     * (experimental) A strategy for how to handle symlinks.
     *
     * @default SymlinkFollowMode.NEVER
     * @experimental
     */
    readonly follow?: SymlinkFollowMode;
    /**
     * (experimental) Glob patterns to exclude from the copy.
     *
     * @default - nothing is excluded
     * @experimental
     */
    readonly exclude?: string[];
}
/**
 * (experimental) Options related to calculating source hash.
 *
 * @experimental
 */
export interface FingerprintOptions extends CopyOptions {
    /**
     * (experimental) Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
     *
     * @default - hash is only based on source content
     * @experimental
     */
    readonly extraHash?: string;
}
