import { Duration } from './duration';
/**
 * (experimental) Represents a date of expiration.
 *
 * The amount can be specified either as a Date object, timestamp, Duration or string.
 *
 * @experimental
 */
export declare class Expiration {
    /**
     * (experimental) Expire at the specified date.
     *
     * @param d date to expire at.
     * @experimental
     */
    static atDate(d: Date): Expiration;
    /**
     * (experimental) Expire at the specified timestamp.
     *
     * @param t timestamp in unix milliseconds.
     * @experimental
     */
    static atTimestamp(t: number): Expiration;
    /**
     * (experimental) Expire once the specified duration has passed since deployment time.
     *
     * @param t the duration to wait before expiring.
     * @experimental
     */
    static after(t: Duration): Expiration;
    /**
     * (experimental) Expire at specified date, represented as a string.
     *
     * @param s the string that represents date to expire at.
     * @experimental
     */
    static fromString(s: string): Expiration;
    /**
     * (experimental) Expiration value as a Date object.
     *
     * @experimental
     */
    readonly date: Date;
    private constructor();
    /**
     * (experimental) Exipration Value in a formatted Unix Epoch Time in seconds.
     *
     * @experimental
     */
    toEpoch(): number;
    /**
     * (experimental) Check if Exipiration expires before input.
     *
     * @param t the duration to check against.
     * @experimental
     */
    isBefore(t: Duration): boolean;
    /**
     * (experimental) Check if Exipiration expires after input.
     *
     * @param t the duration to check against.
     * @experimental
     */
    isAfter(t: Duration): boolean;
}
