import { Construct } from 'constructs';
import { RemovalPolicy } from './removal-policy';
import { Resource } from './resource';
/**
 * (experimental) Properties to provide a Lambda-backed custom resource.
 *
 * @experimental
 */
export interface CustomResourceProps {
    /**
     * (experimental) The ARN of the provider which implements this custom resource type.
     *
     * You can implement a provider by listening to raw AWS CloudFormation events
     * and specify the ARN of an SNS topic (`topic.topicArn`) or the ARN of an AWS
     * Lambda function (`lambda.functionArn`) or use the CDK's custom [resource
     * provider framework] which makes it easier to implement robust providers.
     *
     * [resource provider framework]:
     * https://docs.aws.amazon.com/cdk/api/latest/docs/custom-resources-readme.html
     *
     * Provider framework:
     *
     * ```ts
     * // use the provider framework from aws-cdk/custom-resources:
     * const provider = new custom_resources.Provider({
     *    onEventHandler: myOnEventLambda,
     *    isCompleteHandler: myIsCompleteLambda, // optional
     * });
     *
     * new CustomResource(this, 'MyResource', {
     *    serviceToken: provider.serviceToken
     * });
     * ```
     *
     * AWS Lambda function:
     *
     * ```ts
     * // invoke an AWS Lambda function when a lifecycle event occurs:
     * serviceToken: myFunction.functionArn
     * ```
     *
     * SNS topic:
     *
     * ```ts
     * // publish lifecycle events to an SNS topic:
     * serviceToken: myTopic.topicArn
     * ```
     *
     * @experimental
     */
    readonly serviceToken: string;
    /**
     * (experimental) Properties to pass to the Lambda.
     *
     * @default - No properties.
     * @experimental
     */
    readonly properties?: {
        [key: string]: any;
    };
    /**
     * (experimental) For custom resources, you can specify AWS::CloudFormation::CustomResource (the default) as the resource type, or you can specify your own resource type name.
     *
     * For example, you can use "Custom::MyCustomResourceTypeName".
     *
     * Custom resource type names must begin with "Custom::" and can include
     * alphanumeric characters and the following characters: _@-. You can specify
     * a custom resource type name up to a maximum length of 60 characters. You
     * cannot change the type during an update.
     *
     * Using your own resource type names helps you quickly differentiate the
     * types of custom resources in your stack. For example, if you had two custom
     * resources that conduct two different ping tests, you could name their type
     * as Custom::PingTester to make them easily identifiable as ping testers
     * (instead of using AWS::CloudFormation::CustomResource).
     *
     * @default - AWS::CloudFormation::CustomResource
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html#aws-cfn-resource-type-name
     * @experimental
     */
    readonly resourceType?: string;
    /**
     * (experimental) The policy to apply when this resource is removed from the application.
     *
     * @default cdk.RemovalPolicy.Destroy
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * (experimental) Convert all property keys to pascal case.
     *
     * @default false
     * @experimental
     */
    readonly pascalCaseProperties?: boolean;
}
/**
 * (experimental) Custom resource that is implemented using a Lambda.
 *
 * As a custom resource author, you should be publishing a subclass of this class
 * that hides the choice of provider, and accepts a strongly-typed properties
 * object with the properties your provider accepts.
 *
 * @experimental
 * @resource AWS::CloudFormation::CustomResource
 */
export declare class CustomResource extends Resource {
    private readonly resource;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CustomResourceProps);
    /**
     * (experimental) The physical name of this custom resource.
     *
     * @experimental
     */
    get ref(): string;
    /**
     * (experimental) Returns the value of an attribute of the custom resource of an arbitrary type.
     *
     * Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute.
     * @returns a token for `Fn::GetAtt`. Use `Token.asXxx` to encode the returned `Reference` as a specific type or
     * use the convenience `getAttString` for string attributes.
     * @experimental
     */
    getAtt(attributeName: string): import("./reference").Reference;
    /**
     * (experimental) Returns the value of an attribute of the custom resource of type string.
     *
     * Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute.
     * @returns a token for `Fn::GetAtt` encoded as a string.
     * @experimental
     */
    getAttString(attributeName: string): string;
}
