/**
 * Constructs compatibility layer.
 *
 * This file includes types that shadow types in the "constructs" module in
 * order to allow backwards-compatiblity in the AWS CDK v1.0 release line.
 *
 * There are pretty ugly hacks here, which mostly involve downcasting types to
 * adhere to legacy AWS CDK APIs.
 *
 * This file, in its entirety, is expected to be removed in v2.0.
 */
import * as cxapi from "../../cx-api";
import * as constructs from 'constructs';
import { IAspect } from './aspect';
import { IDependable } from './dependency';
/**
 * (experimental) Represents a construct.
 *
 * @experimental
 */
export interface IConstruct extends constructs.IConstruct, IDependable {
    /**
     * (experimental) The construct tree node for this construct.
     *
     * @experimental
     */
    readonly node: ConstructNode;
}
/**
 * (experimental) Represents a single session of synthesis.
 *
 * Passed into `Construct.synthesize()` methods.
 *
 * @experimental
 */
export interface ISynthesisSession {
    /**
     * (experimental) The output directory for this synthesis session.
     *
     * @experimental
     */
    outdir: string;
    /**
     * (experimental) Cloud assembly builder.
     *
     * @experimental
     */
    assembly: cxapi.CloudAssemblyBuilder;
}
/**
 * (experimental) Represents the building block of the construct graph.
 *
 * All constructs besides the root construct must be created within the scope of
 * another construct.
 *
 * @experimental
 */
export declare class Construct extends constructs.Construct implements IConstruct {
    /**
     * (experimental) Return whether the given object is a Construct.
     *
     * @experimental
     */
    static isConstruct(x: any): x is Construct;
    /**
     * (experimental) The construct tree node associated with this construct.
     *
     * @experimental
     */
    readonly node: ConstructNode;
    /**
     * @experimental
     */
    constructor(scope: constructs.Construct, id: string);
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @returns An array of validation error messages, or an empty array if the construct is valid.
     * @experimental
     */
    protected onValidate(): string[];
    /**
     * (experimental) Perform final modifications before synthesis.
     *
     * This method can be implemented by derived constructs in order to perform
     * final changes before synthesis. prepare() will be called after child
     * constructs have been prepared.
     *
     * This is an advanced framework feature. Only use this if you
     * understand the implications.
     *
     * @experimental
     */
    protected onPrepare(): void;
    /**
     * (experimental) Allows this construct to emit artifacts into the cloud assembly during synthesis.
     *
     * This method is usually implemented by framework-level constructs such as `Stack` and `Asset`
     * as they participate in synthesizing the cloud assembly.
     *
     * @param session The synthesis session.
     * @experimental
     */
    protected onSynthesize(session: constructs.ISynthesisSession): void;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @returns An array of validation error messages, or an empty array if the construct is valid.
     * @experimental
     */
    protected validate(): string[];
    /**
     * (experimental) Perform final modifications before synthesis.
     *
     * This method can be implemented by derived constructs in order to perform
     * final changes before synthesis. prepare() will be called after child
     * constructs have been prepared.
     *
     * This is an advanced framework feature. Only use this if you
     * understand the implications.
     *
     * @experimental
     */
    protected prepare(): void;
    /**
     * (experimental) Allows this construct to emit artifacts into the cloud assembly during synthesis.
     *
     * This method is usually implemented by framework-level constructs such as `Stack` and `Asset`
     * as they participate in synthesizing the cloud assembly.
     *
     * @param session The synthesis session.
     * @experimental
     */
    protected synthesize(session: ISynthesisSession): void;
}
/**
 * (experimental) In what order to return constructs.
 *
 * @experimental
 */
export declare enum ConstructOrder {
    /**
     * (experimental) Depth-first, pre-order.
     *
     * @experimental
     */
    PREORDER = 0,
    /**
     * (experimental) Depth-first, post-order (leaf nodes first).
     *
     * @experimental
     */
    POSTORDER = 1
}
/**
 * (deprecated) Options for synthesis.
 *
 * @deprecated use `app.synth()` or `stage.synth()` instead
 */
export interface SynthesisOptions extends cxapi.AssemblyBuildOptions {
    /**
     * (deprecated) The output directory into which to synthesize the cloud assembly.
     *
     * @default - creates a temporary directory
     * @deprecated
     */
    readonly outdir?: string;
    /**
     * (deprecated) Whether synthesis should skip the validation phase.
     *
     * @default false
     * @deprecated
     */
    readonly skipValidation?: boolean;
}
/**
 * (experimental) Represents the construct node in the scope tree.
 *
 * @experimental
 */
export declare class ConstructNode {
    /**
     * (experimental) Separator used to delimit construct path components.
     *
     * @experimental
     */
    static readonly PATH_SEP = "/";
    /**
     * Returns the wrapping `@aws-cdk/core.ConstructNode` instance from a `constructs.ConstructNode`.
     *
     * @internal
     */
    static _unwrap(c: constructs.Node): ConstructNode;
    /**
     * (deprecated) Synthesizes a CloudAssembly from a construct tree.
     *
     * @param node The root of the construct tree.
     * @param options Synthesis options.
     * @deprecated Use `app.synth()` or `stage.synth()` instead
     */
    static synth(node: ConstructNode, options?: SynthesisOptions): cxapi.CloudAssembly;
    /**
     * (deprecated) Invokes "prepare" on all constructs (depth-first, post-order) in the tree under `node`.
     *
     * @param node The root node.
     * @deprecated Use `app.synth()` instead
     */
    static prepare(node: ConstructNode): void;
    /**
     * (experimental) Invokes "validate" on all constructs in the tree (depth-first, pre-order) and returns the list of all errors.
     *
     * An empty list indicates that there are no errors.
     *
     * @param node The root node.
     * @experimental
     */
    static validate(node: ConstructNode): ValidationError[];
    /**
     * @internal
     */
    readonly _actualNode: constructs.Node;
    /**
     * The Construct class that hosts this API.
     */
    private readonly host;
    /**
     * @experimental
     */
    constructor(host: Construct, scope: IConstruct, id: string);
    /**
     * (experimental) Returns the scope in which this construct is defined.
     *
     * The value is `undefined` at the root of the construct scope tree.
     *
     * @experimental
     */
    get scope(): IConstruct | undefined;
    /**
     * (experimental) The id of this construct within the current scope.
     *
     * This is a a scope-unique id. To obtain an app-unique id for this construct, use `uniqueId`.
     *
     * @experimental
     */
    get id(): string;
    /**
     * (experimental) The full, absolute path of this construct in the tree.
     *
     * Components are separated by '/'.
     *
     * @experimental
     */
    get path(): string;
    /**
     * (deprecated) A tree-global unique alphanumeric identifier for this construct.
     *
     * Includes
     * all components of the tree.
     *
     * @deprecated use `node.addr` to obtain a consistent 42 character address for
     * this node (see https://github.com/aws/constructs/pull/314)
     */
    get uniqueId(): string;
    /**
     * (experimental) Returns an opaque tree-unique address for this construct.
     *
     * Addresses are 42 characters hexadecimal strings. They begin with "c8"
     * followed by 40 lowercase hexadecimal characters (0-9a-f).
     *
     * Addresses are calculated using a SHA-1 of the components of the construct
     * path.
     *
     * To enable refactorings of construct trees, constructs with the ID `Default`
     * will be excluded from the calculation. In those cases constructs in the
     * same tree may have the same addreess.
     *
     * @experimental
     * @example
     *
     * c83a2846e506bcc5f10682b564084bca2d275709ee
     */
    get addr(): string;
    /**
     * (experimental) Return a direct child by id, or undefined.
     *
     * @param id Identifier of direct child.
     * @returns the child if found, or undefined
     * @experimental
     */
    tryFindChild(id: string): IConstruct | undefined;
    /**
     * (experimental) Return a direct child by id.
     *
     * Throws an error if the child is not found.
     *
     * @param id Identifier of direct child.
     * @returns Child with the given id.
     * @experimental
     */
    findChild(id: string): IConstruct;
    /**
     * (experimental) Returns the child construct that has the id `Default` or `Resource"`.
     *
     * This is usually the construct that provides the bulk of the underlying functionality.
     * Useful for modifications of the underlying construct that are not available at the higher levels.
     * Override the defaultChild property.
     *
     * This should only be used in the cases where the correct
     * default child is not named 'Resource' or 'Default' as it
     * should be.
     *
     * If you set this to undefined, the default behavior of finding
     * the child named 'Resource' or 'Default' will be used.
     *
     * @returns a construct or undefined if there is no default child
     * @experimental
     * @throws if there is more than one child
     */
    get defaultChild(): IConstruct | undefined;
    /**
     * (experimental) Returns the child construct that has the id `Default` or `Resource"`.
     *
     * This is usually the construct that provides the bulk of the underlying functionality.
     * Useful for modifications of the underlying construct that are not available at the higher levels.
     * Override the defaultChild property.
     *
     * This should only be used in the cases where the correct
     * default child is not named 'Resource' or 'Default' as it
     * should be.
     *
     * If you set this to undefined, the default behavior of finding
     * the child named 'Resource' or 'Default' will be used.
     *
     * @returns a construct or undefined if there is no default child
     * @experimental
     * @throws if there is more than one child
     */
    set defaultChild(value: IConstruct | undefined);
    /**
     * (experimental) All direct children of this construct.
     *
     * @experimental
     */
    get children(): IConstruct[];
    /**
     * (experimental) Return this construct and all of its children in the given order.
     *
     * @experimental
     */
    findAll(order?: ConstructOrder): IConstruct[];
    /**
     * (experimental) This can be used to set contextual values.
     *
     * Context must be set before any children are added, since children may consult context info during construction.
     * If the key already exists, it will be overridden.
     *
     * @param key The context key.
     * @param value The context value.
     * @experimental
     */
    setContext(key: string, value: any): void;
    /**
     * (experimental) Retrieves a value from tree context.
     *
     * Context is usually initialized at the root, but can be overridden at any point in the tree.
     *
     * @param key The context key.
     * @returns The context value or `undefined` if there is no context value for the key.
     * @experimental
     */
    tryGetContext(key: string): any;
    /**
     * (experimental) An immutable array of metadata objects associated with this construct.
     *
     * This can be used, for example, to implement support for deprecation notices, source mapping, etc.
     *
     * @experimental
     */
    get metadata(): cxapi.MetadataEntry[];
    /**
     * (experimental) Adds a metadata entry to this construct.
     *
     * Entries are arbitrary values and will also include a stack trace to allow tracing back to
     * the code location for when the entry was added. It can be used, for example, to include source
     * mapping in CloudFormation templates to improve diagnostics.
     *
     * @param type a string denoting the type of metadata.
     * @param data the value of the metadata (can be a Token).
     * @param fromFunction a function under which to restrict the metadata entry's stack trace (defaults to this.addMetadata).
     * @experimental
     */
    addMetadata(type: string, data: any, fromFunction?: any): void;
    /**
     * (deprecated) DEPRECATED: Adds a { "info": <message> } metadata entry to this construct.
     *
     * The toolkit will display the info message when apps are synthesized.
     *
     * @param message The info message.
     * @deprecated use `Annotations.of(construct).addInfo()`
     */
    addInfo(message: string): void;
    /**
     * (deprecated) DEPRECATED: Adds a { "warning": <message> } metadata entry to this construct.
     *
     * The toolkit will display the warning when an app is synthesized, or fail
     * if run in --strict mode.
     *
     * @param message The warning message.
     * @deprecated use `Annotations.of(construct).addWarning()`
     */
    addWarning(message: string): void;
    /**
     * (deprecated) DEPRECATED: Adds an { "error": <message> } metadata entry to this construct.
     *
     * The toolkit will fail synthesis when errors are reported.
     *
     * @param message The error message.
     * @deprecated use `Annotations.of(construct).addError()`
     */
    addError(message: string): void;
    /**
     * (deprecated) DEPRECATED: Applies the aspect to this Constructs node.
     *
     * @deprecated This API is going to be removed in the next major version of
     * the AWS CDK. Please use `Aspects.of(scope).add()` instead.
     */
    applyAspect(aspect: IAspect): void;
    /**
     * (experimental) All parent scopes of this construct.
     *
     * @returns a list of parent scopes. The last element in the list will always
     * be the current construct and the first element will be the root of the
     * tree.
     * @experimental
     */
    get scopes(): IConstruct[];
    /**
     * @returns The root of the construct tree.
     * @experimental
     */
    get root(): IConstruct;
    /**
     * (experimental) Returns true if this construct or the scopes in which it is defined are locked.
     *
     * @experimental
     */
    get locked(): boolean;
    /**
     * (experimental) Add an ordering dependency on another Construct.
     *
     * All constructs in the dependency's scope will be deployed before any
     * construct in this construct's scope.
     *
     * @experimental
     */
    addDependency(...dependencies: IDependable[]): void;
    /**
     * (experimental) Return all dependencies registered on this node or any of its children.
     *
     * @experimental
     */
    get dependencies(): Dependency[];
    /**
     * (experimental) Remove the child with the given name, if present.
     *
     * @returns Whether a child with the given name was deleted.
     * @experimental
     */
    tryRemoveChild(childName: string): boolean;
}
/**
 * (experimental) An error returned during the validation phase.
 *
 * @experimental
 */
export interface ValidationError {
    /**
     * (experimental) The construct which emitted the error.
     *
     * @experimental
     */
    readonly source: Construct;
    /**
     * (experimental) The error message.
     *
     * @experimental
     */
    readonly message: string;
}
/**
 * (experimental) A single dependency.
 *
 * @experimental
 */
export interface Dependency {
    /**
     * (experimental) Source the dependency.
     *
     * @experimental
     */
    readonly source: IConstruct;
    /**
     * (experimental) Target of the dependency.
     *
     * @experimental
     */
    readonly target: IConstruct;
}
