"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScopedAws = exports.Aws = void 0;
const cfn_reference_1 = require("./private/cfn-reference");
const token_1 = require("./token");
const AWS_ACCOUNTID = 'AWS::AccountId';
const AWS_URLSUFFIX = 'AWS::URLSuffix';
const AWS_NOTIFICATIONARNS = 'AWS::NotificationARNs';
const AWS_PARTITION = 'AWS::Partition';
const AWS_REGION = 'AWS::Region';
const AWS_STACKID = 'AWS::StackId';
const AWS_STACKNAME = 'AWS::StackName';
const AWS_NOVALUE = 'AWS::NoValue';
/**
 * (experimental) Accessor for pseudo parameters.
 *
 * Since pseudo parameters need to be anchored to a stack somewhere in the
 * construct tree, this class takes an scope parameter; the pseudo parameter
 * values can be obtained as properties from an scoped object.
 *
 * @experimental
 */
class Aws {
    constructor() { }
}
exports.Aws = Aws;
/**
 * @experimental
 */
Aws.ACCOUNT_ID = pseudoString(AWS_ACCOUNTID);
/**
 * @experimental
 */
Aws.URL_SUFFIX = pseudoString(AWS_URLSUFFIX);
/**
 * @experimental
 */
Aws.NOTIFICATION_ARNS = token_1.Token.asList({ Ref: AWS_NOTIFICATIONARNS }, { displayHint: AWS_NOTIFICATIONARNS });
/**
 * @experimental
 */
Aws.PARTITION = pseudoString(AWS_PARTITION);
/**
 * @experimental
 */
Aws.REGION = pseudoString(AWS_REGION);
/**
 * @experimental
 */
Aws.STACK_ID = pseudoString(AWS_STACKID);
/**
 * @experimental
 */
Aws.STACK_NAME = pseudoString(AWS_STACKNAME);
/**
 * @experimental
 */
Aws.NO_VALUE = pseudoString(AWS_NOVALUE);
/**
 * (experimental) Accessor for scoped pseudo parameters.
 *
 * These pseudo parameters are anchored to a stack somewhere in the construct
 * tree, and their values will be exported automatically.
 *
 * @experimental
 */
class ScopedAws {
    /**
     * @experimental
     */
    constructor(scope) {
        this.scope = scope;
    }
    /**
     * @experimental
     */
    get accountId() {
        return this.asString(AWS_ACCOUNTID);
    }
    /**
     * @experimental
     */
    get urlSuffix() {
        return this.asString(AWS_URLSUFFIX);
    }
    /**
     * @experimental
     */
    get notificationArns() {
        return token_1.Token.asList(cfn_reference_1.CfnReference.forPseudo(AWS_NOTIFICATIONARNS, this.scope), {
            displayHint: AWS_NOTIFICATIONARNS,
        });
    }
    /**
     * @experimental
     */
    get partition() {
        return this.asString(AWS_PARTITION);
    }
    /**
     * @experimental
     */
    get region() {
        return this.asString(AWS_REGION);
    }
    /**
     * @experimental
     */
    get stackId() {
        return this.asString(AWS_STACKID);
    }
    /**
     * @experimental
     */
    get stackName() {
        return this.asString(AWS_STACKNAME);
    }
    asString(name) {
        return token_1.Token.asString(cfn_reference_1.CfnReference.forPseudo(name, this.scope), { displayHint: name });
    }
}
exports.ScopedAws = ScopedAws;
function pseudoString(name) {
    // we don't want any ':' in the serialized form,
    // as ':' is the ARN separator,
    // and so we don't want ARN components
    // (which these CFN references like AWS::Partition certainly can be)
    // to contain ':'s themselves
    return token_1.Token.asString({ Ref: name }, { displayHint: name.replace('::', '.') });
}
//# sourceMappingURL=data:application/json;base64,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