import { Construct } from 'constructs';
import { CfnElement } from './cfn-element';
/**
 * @experimental
 */
export interface CfnIncludeProps {
    /**
     * (experimental) The CloudFormation template to include in the stack (as is).
     *
     * @experimental
     */
    readonly template: object;
}
/**
 * (experimental) Includes a CloudFormation template into a stack.
 *
 * All elements of the template will be merged into
 * the current stack, together with any elements created programmatically.
 *
 * @experimental
 */
export declare class CfnInclude extends CfnElement {
    /**
     * (experimental) The included template.
     *
     * @experimental
     */
    readonly template: object;
    /**
     * (experimental) Creates an adopted template construct.
     *
     * The template will be incorporated into the stack as-is with no changes at all.
     * This means that logical IDs of entities within this template may conflict with logical IDs of entities that are part of the
     * stack.
     *
     * @param scope The parent construct of this template.
     * @param id The ID of this construct.
     * @param props Initialization properties.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CfnIncludeProps);
    /**
     * @internal
     */
    _toCloudFormation(): object;
}
