"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnHook = void 0;
const cfn_element_1 = require("./cfn-element");
const util_1 = require("./util");
/**
 * (experimental) Represents a CloudFormation resource.
 *
 * @experimental
 */
class CfnHook extends cfn_element_1.CfnElement {
    /**
     * (experimental) Creates a new Hook object.
     *
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.type = props.type;
        this._cfnHookProperties = props.properties;
    }
    /** @internal */
    _toCloudFormation() {
        return {
            Hooks: {
                [this.logicalId]: {
                    Type: this.type,
                    Properties: util_1.ignoreEmpty(this.renderProperties(this._cfnHookProperties)),
                },
            },
        };
    }
    /**
     * @experimental
     */
    renderProperties(props) {
        return props;
    }
}
exports.CfnHook = CfnHook;
//# sourceMappingURL=data:application/json;base64,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