import { Construct } from 'constructs';
import { CfnElement } from './cfn-element';
/**
 * (experimental) Construction properties of {@link CfnHook}.
 *
 * @experimental
 */
export interface CfnHookProps {
    /**
     * (experimental) The type of the hook (for example, "AWS::CodeDeploy::BlueGreen").
     *
     * @experimental
     */
    readonly type: string;
    /**
     * (experimental) The properties of the hook.
     *
     * @default - no properties
     * @experimental
     */
    readonly properties?: {
        [name: string]: any;
    };
}
/**
 * (experimental) Represents a CloudFormation resource.
 *
 * @experimental
 */
export declare class CfnHook extends CfnElement {
    /**
     * (experimental) The type of the hook (for example, "AWS::CodeDeploy::BlueGreen").
     *
     * @experimental
     */
    readonly type: string;
    private readonly _cfnHookProperties?;
    /**
     * (experimental) Creates a new Hook object.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CfnHookProps);
    /** @internal */
    _toCloudFormation(): object;
    /**
     * @experimental
     */
    protected renderProperties(props?: {
        [key: string]: any;
    }): {
        [key: string]: any;
    } | undefined;
}
