"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnCodeDeployBlueGreenHook = exports.CfnTrafficRoutingType = void 0;
const cfn_hook_1 = require("./cfn-hook");
const util_1 = require("./util");
/**
 * (experimental) The possible types of traffic shifting for the blue-green deployment configuration.
 *
 * The type of the {@link CfnTrafficRoutingConfig.type} property.
 *
 * @experimental
 */
var CfnTrafficRoutingType;
(function (CfnTrafficRoutingType) {
    CfnTrafficRoutingType["ALL_AT_ONCE"] = "AllAtOnce";
    CfnTrafficRoutingType["TIME_BASED_CANARY"] = "TimeBasedCanary";
    CfnTrafficRoutingType["TIME_BASED_LINEAR"] = "TimeBasedLinear";
})(CfnTrafficRoutingType = exports.CfnTrafficRoutingType || (exports.CfnTrafficRoutingType = {}));
/**
 * (experimental) A CloudFormation Hook for CodeDeploy blue-green ECS deployments.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/blue-green.html#blue-green-template-reference
 * @experimental
 */
class CfnCodeDeployBlueGreenHook extends cfn_hook_1.CfnHook {
    /**
     * (experimental) Creates a new CodeDeploy blue-green ECS Hook.
     *
     * @param scope the scope to create the hook in (usually the containing Stack object).
     * @param id the identifier of the construct - will be used to generate the logical ID of the Hook.
     * @param props the properties of the Hook.
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'AWS::CodeDeploy::BlueGreen',
        });
        this._serviceRole = props.serviceRole;
        this._applications = props.applications;
        this._trafficRoutingConfig = props.trafficRoutingConfig;
        this._additionalOptions = props.additionalOptions;
        this._lifecycleEventHooks = props.lifecycleEventHooks;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, hookAttributes, options) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
        hookAttributes = hookAttributes || {};
        const hookProperties = options.parser.parseValue(hookAttributes.Properties);
        return new CfnCodeDeployBlueGreenHook(scope, id, {
            serviceRole: hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.ServiceRole,
            applications: (_a = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.Applications) === null || _a === void 0 ? void 0 : _a.map(applicationFromCloudFormation),
            trafficRoutingConfig: {
                type: (_b = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.TrafficRoutingConfig) === null || _b === void 0 ? void 0 : _b.Type,
                timeBasedCanary: {
                    stepPercentage: (_d = (_c = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.TrafficRoutingConfig) === null || _c === void 0 ? void 0 : _c.TimeBasedCanary) === null || _d === void 0 ? void 0 : _d.StepPercentage,
                    bakeTimeMins: (_f = (_e = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.TrafficRoutingConfig) === null || _e === void 0 ? void 0 : _e.TimeBasedCanary) === null || _f === void 0 ? void 0 : _f.BakeTimeMins,
                },
                timeBasedLinear: {
                    stepPercentage: (_h = (_g = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.TrafficRoutingConfig) === null || _g === void 0 ? void 0 : _g.TimeBasedLinear) === null || _h === void 0 ? void 0 : _h.StepPercentage,
                    bakeTimeMins: (_k = (_j = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.TrafficRoutingConfig) === null || _j === void 0 ? void 0 : _j.TimeBasedLinear) === null || _k === void 0 ? void 0 : _k.BakeTimeMins,
                },
            },
            additionalOptions: {
                terminationWaitTimeInMinutes: (_l = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.AdditionalOptions) === null || _l === void 0 ? void 0 : _l.TerminationWaitTimeInMinutes,
            },
            lifecycleEventHooks: {
                beforeInstall: (_m = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.LifecycleEventHooks) === null || _m === void 0 ? void 0 : _m.BeforeInstall,
                afterInstall: (_o = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.LifecycleEventHooks) === null || _o === void 0 ? void 0 : _o.AfterInstall,
                afterAllowTestTraffic: (_p = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.LifecycleEventHooks) === null || _p === void 0 ? void 0 : _p.AfterAllowTestTraffic,
                beforeAllowTraffic: (_q = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.LifecycleEventHooks) === null || _q === void 0 ? void 0 : _q.BeforeAllowTraffic,
                afterAllowTraffic: (_r = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.LifecycleEventHooks) === null || _r === void 0 ? void 0 : _r.AfterAllowTraffic,
            },
        });
        function applicationFromCloudFormation(app) {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w;
            const target = findResource((_a = app === null || app === void 0 ? void 0 : app.Target) === null || _a === void 0 ? void 0 : _a.LogicalID);
            const taskDefinitions = (_c = (_b = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _b === void 0 ? void 0 : _b.TaskDefinitions) === null || _c === void 0 ? void 0 : _c.map((td) => findResource(td));
            const taskSets = (_e = (_d = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _d === void 0 ? void 0 : _d.TaskSets) === null || _e === void 0 ? void 0 : _e.map((ts) => findResource(ts));
            const prodTrafficRoute = findResource((_h = (_g = (_f = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _f === void 0 ? void 0 : _f.TrafficRouting) === null || _g === void 0 ? void 0 : _g.ProdTrafficRoute) === null || _h === void 0 ? void 0 : _h.LogicalID);
            const testTrafficRoute = findResource((_l = (_k = (_j = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _j === void 0 ? void 0 : _j.TrafficRouting) === null || _k === void 0 ? void 0 : _k.TestTrafficRoute) === null || _l === void 0 ? void 0 : _l.LogicalID);
            const targetGroups = (_p = (_o = (_m = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _m === void 0 ? void 0 : _m.TrafficRouting) === null || _o === void 0 ? void 0 : _o.TargetGroups) === null || _p === void 0 ? void 0 : _p.map((tg) => findResource(tg));
            return {
                target: {
                    type: (_q = app === null || app === void 0 ? void 0 : app.Target) === null || _q === void 0 ? void 0 : _q.Type,
                    logicalId: target === null || target === void 0 ? void 0 : target.logicalId,
                },
                ecsAttributes: {
                    taskDefinitions: taskDefinitions === null || taskDefinitions === void 0 ? void 0 : taskDefinitions.map(td => td === null || td === void 0 ? void 0 : td.logicalId),
                    taskSets: taskSets === null || taskSets === void 0 ? void 0 : taskSets.map(ts => ts === null || ts === void 0 ? void 0 : ts.logicalId),
                    trafficRouting: {
                        prodTrafficRoute: {
                            type: (_t = (_s = (_r = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _r === void 0 ? void 0 : _r.TrafficRouting) === null || _s === void 0 ? void 0 : _s.ProdTrafficRoute) === null || _t === void 0 ? void 0 : _t.Type,
                            logicalId: prodTrafficRoute === null || prodTrafficRoute === void 0 ? void 0 : prodTrafficRoute.logicalId,
                        },
                        testTrafficRoute: {
                            type: (_w = (_v = (_u = app === null || app === void 0 ? void 0 : app.ECSAttributes) === null || _u === void 0 ? void 0 : _u.TrafficRouting) === null || _v === void 0 ? void 0 : _v.TestTrafficRoute) === null || _w === void 0 ? void 0 : _w.Type,
                            logicalId: testTrafficRoute === null || testTrafficRoute === void 0 ? void 0 : testTrafficRoute.logicalId,
                        },
                        targetGroups: targetGroups === null || targetGroups === void 0 ? void 0 : targetGroups.map((tg) => tg === null || tg === void 0 ? void 0 : tg.logicalId),
                    },
                },
            };
        }
        function findResource(logicalId) {
            if (logicalId == null) {
                return undefined;
            }
            const ret = options.parser.finder.findResource(logicalId);
            if (!ret) {
                throw new Error(`Hook '${id}' references resource '${logicalId}' that was not found in the template`);
            }
            return ret;
        }
    }
    /**
     * (experimental) The IAM Role for CloudFormation to use to perform blue-green deployments.
     *
     * @experimental
     */
    get serviceRole() {
        return this._serviceRole;
    }
    /**
     * (experimental) The IAM Role for CloudFormation to use to perform blue-green deployments.
     *
     * @experimental
     */
    set serviceRole(serviceRole) {
        this._serviceRole = serviceRole;
    }
    /**
     * (experimental) Properties of the Amazon ECS applications being deployed.
     *
     * @experimental
     */
    get applications() {
        return this._applications;
    }
    /**
     * (experimental) Properties of the Amazon ECS applications being deployed.
     *
     * @experimental
     */
    set applications(value) {
        this._applications = value;
    }
    /**
     * (experimental) Traffic routing configuration settings.
     *
     * @default - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
     * @experimental
     */
    get trafficRoutingConfig() {
        return this._trafficRoutingConfig;
    }
    /**
     * (experimental) Traffic routing configuration settings.
     *
     * @default - time-based canary traffic shifting, with a 15% step percentage and a five minute bake time
     * @experimental
     */
    set trafficRoutingConfig(value) {
        this._trafficRoutingConfig = value;
    }
    /**
     * (experimental) Additional options for the blue/green deployment.
     *
     * @default - no additional options
     * @experimental
     */
    get additionalOptions() {
        return this._additionalOptions;
    }
    /**
     * (experimental) Additional options for the blue/green deployment.
     *
     * @default - no additional options
     * @experimental
     */
    set additionalOptions(value) {
        this._additionalOptions = value;
    }
    /**
     * (experimental) Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
     *
     * You can use the same function or a different one for deployment lifecycle events.
     * Following completion of the validation tests,
     * the Lambda {@link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
     * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
     *
     * @default - no lifecycle event hooks
     * @experimental
     */
    get lifecycleEventHooks() {
        return this._lifecycleEventHooks;
    }
    /**
     * (experimental) Use lifecycle event hooks to specify a Lambda function that CodeDeploy can call to validate a deployment.
     *
     * You can use the same function or a different one for deployment lifecycle events.
     * Following completion of the validation tests,
     * the Lambda {@link CfnCodeDeployBlueGreenLifecycleEventHooks.afterAllowTraffic}
     * function calls back CodeDeploy and delivers a result of 'Succeeded' or 'Failed'.
     *
     * @default - no lifecycle event hooks
     * @experimental
     */
    set lifecycleEventHooks(value) {
        this._lifecycleEventHooks = value;
    }
    /**
     * @experimental
     */
    renderProperties(_props) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        return {
            ServiceRole: this.serviceRole,
            Applications: this.applications.map((app) => ({
                Target: {
                    Type: app.target.type,
                    LogicalID: app.target.logicalId,
                },
                ECSAttributes: {
                    TaskDefinitions: app.ecsAttributes.taskDefinitions,
                    TaskSets: app.ecsAttributes.taskSets,
                    TrafficRouting: {
                        ProdTrafficRoute: {
                            Type: app.ecsAttributes.trafficRouting.prodTrafficRoute.type,
                            LogicalID: app.ecsAttributes.trafficRouting.prodTrafficRoute.logicalId,
                        },
                        TestTrafficRoute: {
                            Type: app.ecsAttributes.trafficRouting.testTrafficRoute.type,
                            LogicalID: app.ecsAttributes.trafficRouting.testTrafficRoute.logicalId,
                        },
                        TargetGroups: app.ecsAttributes.trafficRouting.targetGroups,
                    },
                },
            })),
            TrafficRoutingConfig: util_1.undefinedIfAllValuesAreEmpty({
                Type: (_a = this.trafficRoutingConfig) === null || _a === void 0 ? void 0 : _a.type,
                TimeBasedCanary: util_1.undefinedIfAllValuesAreEmpty({
                    StepPercentage: (_c = (_b = this.trafficRoutingConfig) === null || _b === void 0 ? void 0 : _b.timeBasedCanary) === null || _c === void 0 ? void 0 : _c.stepPercentage,
                    BakeTimeMins: (_e = (_d = this.trafficRoutingConfig) === null || _d === void 0 ? void 0 : _d.timeBasedCanary) === null || _e === void 0 ? void 0 : _e.bakeTimeMins,
                }),
                TimeBasedLinear: util_1.undefinedIfAllValuesAreEmpty({
                    StepPercentage: (_g = (_f = this.trafficRoutingConfig) === null || _f === void 0 ? void 0 : _f.timeBasedLinear) === null || _g === void 0 ? void 0 : _g.stepPercentage,
                    BakeTimeMins: (_j = (_h = this.trafficRoutingConfig) === null || _h === void 0 ? void 0 : _h.timeBasedLinear) === null || _j === void 0 ? void 0 : _j.bakeTimeMins,
                }),
            }),
            AdditionalOptions: util_1.undefinedIfAllValuesAreEmpty({
                TerminationWaitTimeInMinutes: (_k = this.additionalOptions) === null || _k === void 0 ? void 0 : _k.terminationWaitTimeInMinutes,
            }),
            LifecycleEventHooks: util_1.undefinedIfAllValuesAreEmpty({
                BeforeInstall: (_l = this.lifecycleEventHooks) === null || _l === void 0 ? void 0 : _l.beforeInstall,
                AfterInstall: (_m = this.lifecycleEventHooks) === null || _m === void 0 ? void 0 : _m.afterInstall,
                AfterAllowTestTraffic: (_o = this.lifecycleEventHooks) === null || _o === void 0 ? void 0 : _o.afterAllowTestTraffic,
                BeforeAllowTraffic: (_p = this.lifecycleEventHooks) === null || _p === void 0 ? void 0 : _p.beforeAllowTraffic,
                AfterAllowTraffic: (_q = this.lifecycleEventHooks) === null || _q === void 0 ? void 0 : _q.afterAllowTraffic,
            }),
        };
    }
}
exports.CfnCodeDeployBlueGreenHook = CfnCodeDeployBlueGreenHook;
//# sourceMappingURL=data:application/json;base64,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