"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Aspects = void 0;
const ASPECTS_SYMBOL = Symbol('cdk-aspects');
/**
 * (experimental) Aspects can be applied to CDK tree scopes and can operate on the tree before synthesis.
 *
 * @experimental
 */
class Aspects {
    // TODO(2.0): private readonly _aspects = new Array<IAspect>();
    constructor(scope) {
        this.scope = scope;
    }
    /**
     * (experimental) Returns the `Aspects` object associated with a construct scope.
     *
     * @param scope The scope for which these aspects will apply.
     * @experimental
     */
    static of(scope) {
        let aspects = scope[ASPECTS_SYMBOL];
        if (!aspects) {
            aspects = new Aspects(scope);
            Object.defineProperty(scope, ASPECTS_SYMBOL, {
                value: aspects,
                configurable: false,
                enumerable: false,
            });
        }
        return aspects;
    }
    /**
     * (experimental) Adds an aspect to apply this scope before synthesis.
     *
     * @param aspect The aspect to add.
     * @experimental
     */
    add(aspect) {
        // TODO(2.0): this._aspects.push(aspect);
        this.scope.node._actualNode.applyAspect(aspect);
    }
    /**
     * (experimental) The list of aspects which were directly applied on this scope.
     *
     * @experimental
     */
    get aspects() {
        // TODO(2.0): return  [ ...this._aspects ];
        return [...this.scope.node._actualNode._aspects]; // clone
    }
}
exports.Aspects = Aspects;
//# sourceMappingURL=data:application/json;base64,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