import { ArtifactProperties } from './artifact-schema';
import { ContextProvider, ContextQueryProperties } from './context-queries';
import { MetadataEntry } from './metadata-schema';
/**
 * (experimental) Type of cloud artifact.
 *
 * @experimental
 */
export declare enum ArtifactType {
    /**
     * (experimental) Stub required because of JSII.
     *
     * @experimental
     */
    NONE = "none",
    /**
     * (experimental) The artifact is an AWS CloudFormation stack.
     *
     * @experimental
     */
    AWS_CLOUDFORMATION_STACK = "aws:cloudformation:stack",
    /**
     * (experimental) The artifact contains the CDK application's construct tree.
     *
     * @experimental
     */
    CDK_TREE = "cdk:tree",
    /**
     * (experimental) Manifest for all assets in the Cloud Assembly.
     *
     * @experimental
     */
    ASSET_MANIFEST = "cdk:asset-manifest",
    /**
     * (experimental) Nested Cloud Assembly.
     *
     * @experimental
     */
    NESTED_CLOUD_ASSEMBLY = "cdk:cloud-assembly"
}
/**
 * (experimental) Information about the application's runtime components.
 *
 * @experimental
 */
export interface RuntimeInfo {
    /**
     * (experimental) The list of libraries loaded in the application, associated with their versions.
     *
     * @experimental
     */
    readonly libraries: {
        [name: string]: string;
    };
}
/**
 * (experimental) Represents a missing piece of context.
 *
 * @experimental
 */
export interface MissingContext {
    /**
     * (experimental) The missing context key.
     *
     * @experimental
     */
    readonly key: string;
    /**
     * (experimental) The provider from which we expect this context key to be obtained.
     *
     * @experimental
     */
    readonly provider: ContextProvider;
    /**
     * (experimental) A set of provider-specific options.
     *
     * @experimental
     */
    readonly props: ContextQueryProperties;
}
/**
 * (experimental) A manifest for a single artifact within the cloud assembly.
 *
 * @experimental
 */
export interface ArtifactManifest {
    /**
     * (experimental) The type of artifact.
     *
     * @experimental
     */
    readonly type: ArtifactType;
    /**
     * (experimental) The environment into which this artifact is deployed.
     *
     * @default - no envrionment.
     * @experimental
     */
    readonly environment?: string;
    /**
     * (experimental) Associated metadata.
     *
     * @default - no metadata.
     * @experimental
     */
    readonly metadata?: {
        [path: string]: MetadataEntry[];
    };
    /**
     * (experimental) IDs of artifacts that must be deployed before this artifact.
     *
     * @default - no dependencies.
     * @experimental
     */
    readonly dependencies?: string[];
    /**
     * (experimental) The set of properties for this artifact (depends on type).
     *
     * @default - no properties.
     * @experimental
     */
    readonly properties?: ArtifactProperties;
}
/**
 * (experimental) A manifest which describes the cloud assembly.
 *
 * @experimental
 */
export interface AssemblyManifest {
    /**
     * (experimental) Protocol version.
     *
     * @experimental
     */
    readonly version: string;
    /**
     * (experimental) The set of artifacts in this assembly.
     *
     * @default - no artifacts.
     * @experimental
     */
    readonly artifacts?: {
        [id: string]: ArtifactManifest;
    };
    /**
     * (experimental) Missing context information.
     *
     * If this field has values, it means that the
     * cloud assembly is not complete and should not be deployed.
     *
     * @default - no missing context.
     * @experimental
     */
    readonly missing?: MissingContext[];
    /**
     * (experimental) Runtime information.
     *
     * @default - no info.
     * @experimental
     */
    readonly runtime?: RuntimeInfo;
}
