/**
 * (experimental) Artifact properties for CloudFormation stacks.
 *
 * @experimental
 */
export interface AwsCloudFormationStackProperties {
    /**
     * (experimental) A file relative to the assembly root which contains the CloudFormation template for this stack.
     *
     * @experimental
     */
    readonly templateFile: string;
    /**
     * (experimental) Values for CloudFormation stack parameters that should be passed when the stack is deployed.
     *
     * @default - No parameters
     * @experimental
     */
    readonly parameters?: {
        [id: string]: string;
    };
    /**
     * (experimental) Values for CloudFormation stack tags that should be passed when the stack is deployed.
     *
     * @default - No tags
     * @experimental
     */
    readonly tags?: {
        [id: string]: string;
    };
    /**
     * (experimental) The name to use for the CloudFormation stack.
     *
     * @default - name derived from artifact ID
     * @experimental
     */
    readonly stackName?: string;
    /**
     * (experimental) Whether to enable termination protection for this stack.
     *
     * @default false
     * @experimental
     */
    readonly terminationProtection?: boolean;
    /**
     * (experimental) The role that needs to be assumed to deploy the stack.
     *
     * @default - No role is assumed (current credentials are used)
     * @experimental
     */
    readonly assumeRoleArn?: string;
    /**
     * (experimental) The role that is passed to CloudFormation to execute the change set.
     *
     * @default - No role is passed (currently assumed role/credentials are used)
     * @experimental
     */
    readonly cloudFormationExecutionRoleArn?: string;
    /**
     * (experimental) If the stack template has already been included in the asset manifest, its asset URL.
     *
     * @default - Not uploaded yet, upload just before deploying
     * @experimental
     */
    readonly stackTemplateAssetObjectUrl?: string;
    /**
     * (experimental) Version of bootstrap stack required to deploy this stack.
     *
     * @default - No bootstrap stack required
     * @experimental
     */
    readonly requiresBootstrapStackVersion?: number;
}
/**
 * (experimental) Artifact properties for the Asset Manifest.
 *
 * @experimental
 */
export interface AssetManifestProperties {
    /**
     * (experimental) Filename of the asset manifest.
     *
     * @experimental
     */
    readonly file: string;
    /**
     * (experimental) Version of bootstrap stack required to deploy this stack.
     *
     * @default - Version 1 (basic modern bootstrap stack)
     * @experimental
     */
    readonly requiresBootstrapStackVersion?: number;
}
/**
 * (experimental) Artifact properties for the Construct Tree Artifact.
 *
 * @experimental
 */
export interface TreeArtifactProperties {
    /**
     * (experimental) Filename of the tree artifact.
     *
     * @experimental
     */
    readonly file: string;
}
/**
 * (experimental) Artifact properties for nested cloud assemblies.
 *
 * @experimental
 */
export interface NestedCloudAssemblyProperties {
    /**
     * (experimental) Relative path to the nested cloud assembly.
     *
     * @experimental
     */
    readonly directoryName: string;
    /**
     * (experimental) Display name for the cloud assembly.
     *
     * @default - The artifact ID
     * @experimental
     */
    readonly displayName?: string;
}
/**
 * Properties for manifest artifacts
 */
export declare type ArtifactProperties = AwsCloudFormationStackProperties | AssetManifestProperties | TreeArtifactProperties | NestedCloudAssemblyProperties;
