import { AwsDestination } from './aws-destination';
/**
 * (experimental) A file asset.
 *
 * @experimental
 */
export interface DockerImageAsset {
    /**
     * (experimental) Source description for file assets.
     *
     * @experimental
     */
    readonly source: DockerImageSource;
    /**
     * (experimental) Destinations for this file asset.
     *
     * @experimental
     */
    readonly destinations: {
        [id: string]: DockerImageDestination;
    };
}
/**
 * (experimental) Properties for how to produce a Docker image from a source.
 *
 * @experimental
 */
export interface DockerImageSource {
    /**
     * (experimental) The directory containing the Docker image build instructions.
     *
     * This path is relative to the asset manifest location.
     *
     * @experimental
     */
    readonly directory: string;
    /**
     * (experimental) The name of the file with build instructions.
     *
     * @default "Dockerfile"
     * @experimental
     */
    readonly dockerFile?: string;
    /**
     * (experimental) Target build stage in a Dockerfile with multiple build stages.
     *
     * @default - The last stage in the Dockerfile
     * @experimental
     */
    readonly dockerBuildTarget?: string;
    /**
     * (experimental) Additional build arguments.
     *
     * @default - No additional build arguments
     * @experimental
     */
    readonly dockerBuildArgs?: {
        [name: string]: string;
    };
}
/**
 * (experimental) Where to publish docker images.
 *
 * @experimental
 */
export interface DockerImageDestination extends AwsDestination {
    /**
     * (experimental) Name of the ECR repository to publish to.
     *
     * @experimental
     */
    readonly repositoryName: string;
    /**
     * (experimental) Tag of the image to publish.
     *
     * @experimental
     */
    readonly imageTag: string;
}
