import { Metric, MetricOptions } from "../../aws-cloudwatch";
import * as iam from "../../aws-iam";
import * as s3 from "../../aws-s3";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { Code } from './code';
import { Schedule } from './schedule';
/**
 * (experimental) Specify a test that the canary should run.
 *
 * @experimental
 */
export declare class Test {
    readonly code: Code;
    readonly handler: string;
    /**
     * (experimental) Specify a custom test with your own code.
     *
     * @param options The configuration options.
     * @returns `Test` associated with the specified Code object
     * @experimental
     */
    static custom(options: CustomTestOptions): Test;
    /**
     * Verifies that the given handler ends in '.handler'. Returns the handler if successful and
     * throws an error if not.
     *
     * @param handler - the handler given by the user
     */
    private static validateHandler;
    /**
     * Construct a Test property
     *
     * @param code The code that the canary should run
     * @param handler The handler of the canary
     */
    private constructor();
}
/**
 * (experimental) Properties for specifying a test.
 *
 * @experimental
 */
export interface CustomTestOptions {
    /**
     * (experimental) The code of the canary script.
     *
     * @experimental
     */
    readonly code: Code;
    /**
     * (experimental) The handler for the code.
     *
     * Must end with `.handler`.
     *
     * @experimental
     */
    readonly handler: string;
}
/**
 * (experimental) Runtime options for a canary.
 *
 * @experimental
 */
export declare class Runtime {
    readonly name: string;
    /**
     * (experimental) `syn-1.0` includes the following:.
     *
     * - Synthetics library 1.0
     * - Synthetics handler code 1.0
     * - Lambda runtime Node.js 10.x
     * - Puppeteer-core version 1.14.0
     * - The Chromium version that matches Puppeteer-core 1.14.0
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html#CloudWatch_Synthetics_runtimeversion-1.0
     * @experimental
     */
    static readonly SYNTHETICS_1_0: Runtime;
    /**
     * (experimental) `syn-nodejs-2.0` includes the following: - Lambda runtime Node.js 10.x - Puppeteer-core version 3.3.0 - Chromium version 81.0.4044.0.
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html#CloudWatch_Synthetics_runtimeversion-2.0
     * @experimental
     */
    static readonly SYNTHETICS_NODEJS_2_0: Runtime;
    /**
     * @param name The name of the runtime version.
     * @experimental
     */
    constructor(name: string);
}
/**
 * (experimental) Options for specifying the s3 location that stores the data of each canary run.
 *
 * The artifacts bucket location **cannot**
 * be updated once the canary is created.
 *
 * @experimental
 */
export interface ArtifactsBucketLocation {
    /**
     * (experimental) The s3 location that stores the data of each run.
     *
     * @experimental
     */
    readonly bucket: s3.IBucket;
    /**
     * (experimental) The S3 bucket prefix.
     *
     * Specify this if you want a more specific path within the artifacts bucket.
     *
     * @default - no prefix
     * @experimental
     */
    readonly prefix?: string;
}
/**
 * (experimental) Properties for a canary.
 *
 * @experimental
 */
export interface CanaryProps {
    /**
     * (experimental) The s3 location that stores the data of the canary runs.
     *
     * @default - A new s3 bucket will be created without a prefix.
     * @experimental
     */
    readonly artifactsBucketLocation?: ArtifactsBucketLocation;
    /**
     * (experimental) Canary execution role.
     *
     * This is the role that will be assumed by the canary upon execution.
     * It controls the permissions that the canary will have. The role must
     * be assumable by the AWS Lambda service principal.
     *
     * If not supplied, a role will be created with all the required permissions.
     * If you provide a Role, you must add the required permissions.
     *
     * @default - A unique role will be generated for this canary.
     * You can add permissions to roles by calling 'addToRolePolicy'.
     * @see required permissions: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-executionrolearn
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) How long the canary will be in a 'RUNNING' state.
     *
     * For example, if you set `timeToLive` to be 1 hour and `schedule` to be `rate(10 minutes)`,
     * your canary will run at 10 minute intervals for an hour, for a total of 6 times.
     *
     * @default - no limit
     * @experimental
     */
    readonly timeToLive?: cdk.Duration;
    /**
     * (experimental) Specify the schedule for how often the canary runs.
     *
     * For example, if you set `schedule` to `rate(10 minutes)`, then the canary will run every 10 minutes.
     * You can set the schedule with `Schedule.rate(Duration)` (recommended) or you can specify an expression using `Schedule.expression()`.
     *
     * @default 'rate(5 minutes)'
     * @experimental
     */
    readonly schedule?: Schedule;
    /**
     * (experimental) Whether or not the canary should start after creation.
     *
     * @default true
     * @experimental
     */
    readonly startAfterCreation?: boolean;
    /**
     * (experimental) How many days should successful runs be retained.
     *
     * @default Duration.days(31)
     * @experimental
     */
    readonly successRetentionPeriod?: cdk.Duration;
    /**
     * (experimental) How many days should failed runs be retained.
     *
     * @default Duration.days(31)
     * @experimental
     */
    readonly failureRetentionPeriod?: cdk.Duration;
    /**
     * (experimental) The name of the canary.
     *
     * Be sure to give it a descriptive name that distinguishes it from
     * other canaries in your account.
     *
     * Do not include secrets or proprietary information in your canary name. The canary name
     * makes up part of the canary ARN, which is included in outbound calls over the internet.
     *
     * @default - A unique name will be generated from the construct ID
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html
     * @experimental
     */
    readonly canaryName?: string;
    /**
     * (experimental) Specify the runtime version to use for the canary.
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html
     * @experimental
     */
    readonly runtime: Runtime;
    /**
     * (experimental) The type of test that you want your canary to run.
     *
     * Use `Test.custom()` to specify the test to run.
     *
     * @experimental
     */
    readonly test: Test;
}
/**
 * (experimental) Define a new Canary.
 *
 * @experimental
 */
export declare class Canary extends cdk.Resource {
    /**
     * (experimental) Execution role associated with this Canary.
     *
     * @experimental
     */
    readonly role: iam.IRole;
    /**
     * (experimental) The canary ID.
     *
     * @experimental
     * @attribute true
     */
    readonly canaryId: string;
    /**
     * (experimental) The state of the canary.
     *
     * For example, 'RUNNING', 'STOPPED', 'NOT STARTED', or 'ERROR'.
     *
     * @experimental
     * @attribute true
     */
    readonly canaryState: string;
    /**
     * (experimental) The canary Name.
     *
     * @experimental
     * @attribute true
     */
    readonly canaryName: string;
    /**
     * (experimental) Bucket where data from each canary run is stored.
     *
     * @experimental
     */
    readonly artifactsBucket: s3.IBucket;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CanaryProps);
    /**
     * (experimental) Measure the Duration of a single canary run, in seconds.
     *
     * @param options - configuration options for the metric.
     * @default avg over 5 minutes
     * @experimental
     */
    metricDuration(options?: MetricOptions): Metric;
    /**
     * (experimental) Measure the percentage of successful canary runs.
     *
     * @param options - configuration options for the metric.
     * @default avg over 5 minutes
     * @experimental
     */
    metricSuccessPercent(options?: MetricOptions): Metric;
    /**
     * (experimental) Measure the number of failed canary runs over a given time period.
     *
     * @param options - configuration options for the metric.
     * @default avg over 5 minutes
     * @experimental
     */
    metricFailed(options?: MetricOptions): Metric;
    /**
     * @param metricName - the name of the metric
     * @param options - configuration options for the metric
     *
     * @returns a CloudWatch metric associated with the canary.
     * @default avg over 5 minutes
     */
    private metric;
    /**
     * Returns a default role for the canary
     */
    private createDefaultRole;
    /**
     * Returns the code object taken in by the canary resource.
     */
    private createCode;
    /**
     * Returns a canary schedule object
     */
    private createSchedule;
    /**
     * Creates a unique name for the canary. The generated name is the physical ID of the canary.
     */
    private generateUniqueName;
}
