import * as cloudwatch from "../../../aws-cloudwatch";
import * as cdk from "../../../core";
import { Construct } from 'constructs';
import { Chain } from '../chain';
import { StateGraph } from '../state-graph';
import { IStepFunctionsTask } from '../step-functions-task';
import { CatchProps, IChainable, INextable, RetryProps } from '../types';
import { State } from './state';
/**
 * (deprecated) Props that are common to all tasks.
 *
 * @deprecated - replaced by service integration specific classes (i.e. LambdaInvoke, SnsPublish)
 */
export interface TaskProps {
    /**
     * (deprecated) Actual task to be invoked in this workflow.
     *
     * @deprecated
     */
    readonly task: IStepFunctionsTask;
    /**
     * (deprecated) An optional description for this state.
     *
     * @default No comment
     * @deprecated
     */
    readonly comment?: string;
    /**
     * (deprecated) JSONPath expression to select part of the state to be the input to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * input to be the empty object {}.
     *
     * @default $
     * @deprecated
     */
    readonly inputPath?: string;
    /**
     * (deprecated) JSONPath expression to select part of the state to be the output to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * output to be the empty object {}.
     *
     * @default $
     * @deprecated
     */
    readonly outputPath?: string;
    /**
     * (deprecated) JSONPath expression to indicate where to inject the state's output.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the state's
     * input to become its output.
     *
     * @default $
     * @deprecated
     */
    readonly resultPath?: string;
    /**
     * (deprecated) Parameters to invoke the task with.
     *
     * It is not recommended to use this field. The object that is passed in
     * the `task` property will take care of returning the right values for the
     * `Parameters` field in the Step Functions definition.
     *
     * The various classes that implement `IStepFunctionsTask` will take a
     * properties which make sense for the task type. For example, for
     * `InvokeFunction` the field that populates the `parameters` field will be
     * called `payload`, and for the `PublishToTopic` the `parameters` field
     * will be populated via a combination of the referenced topic, subject and
     * message.
     *
     * If passed anyway, the keys in this map will override the parameters
     * returned by the task object.
     *
     * @default - Use the parameters implied by the `task` property
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters
     * @deprecated
     */
    readonly parameters?: {
        [name: string]: any;
    };
    /**
     * (deprecated) Maximum run time of this state.
     *
     * If the state takes longer than this amount of time to complete, a 'Timeout' error is raised.
     *
     * @default 60
     * @deprecated
     */
    readonly timeout?: cdk.Duration;
}
/**
 * (deprecated) Define a Task state in the state machine.
 *
 * Reaching a Task state causes some work to be executed, represented by the
 * Task's resource property. Task constructs represent a generic Amazon
 * States Language Task.
 *
 * For some resource types, more specific subclasses of Task may be available
 * which are more convenient to use.
 *
 * @deprecated - replaced by service integration specific classes (i.e. LambdaInvoke, SnsPublish)
 */
export declare class Task extends State implements INextable {
    /**
     * (deprecated) Continuable states of this Chainable.
     *
     * @deprecated
     */
    readonly endStates: INextable[];
    private readonly timeout?;
    private readonly taskProps;
    /**
     * @deprecated
     */
    constructor(scope: Construct, id: string, props: TaskProps);
    /**
     * (deprecated) Add retry configuration for this state.
     *
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     *
     * @deprecated
     */
    addRetry(props?: RetryProps): Task;
    /**
     * (deprecated) Add a recovery handler for this state.
     *
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     *
     * @deprecated
     */
    addCatch(handler: IChainable, props?: CatchProps): Task;
    /**
     * (deprecated) Continue normal execution with the given state.
     *
     * @deprecated
     */
    next(next: IChainable): Chain;
    /**
     * (deprecated) Return the Amazon States Language object for this state.
     *
     * @deprecated
     */
    toStateJson(): object;
    /**
     * (deprecated) Return the given named metric for this Task.
     *
     * @default sum over 5 minutes
     * @deprecated
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (deprecated) The interval, in milliseconds, between the time the Task starts and the time it closes.
     *
     * @default average over 5 minutes
     * @deprecated
     */
    metricRunTime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (deprecated) The interval, in milliseconds, for which the activity stays in the schedule state.
     *
     * @default average over 5 minutes
     * @deprecated
     */
    metricScheduleTime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (deprecated) The interval, in milliseconds, between the time the activity is scheduled and the time it closes.
     *
     * @default average over 5 minutes
     * @deprecated
     */
    metricTime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (deprecated) Metric for the number of times this activity is scheduled.
     *
     * @default sum over 5 minutes
     * @deprecated
     */
    metricScheduled(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (deprecated) Metric for the number of times this activity times out.
     *
     * @default sum over 5 minutes
     * @deprecated
     */
    metricTimedOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (deprecated) Metric for the number of times this activity is started.
     *
     * @default sum over 5 minutes
     * @deprecated
     */
    metricStarted(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (deprecated) Metric for the number of times this activity succeeds.
     *
     * @default sum over 5 minutes
     * @deprecated
     */
    metricSucceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (deprecated) Metric for the number of times this activity fails.
     *
     * @default sum over 5 minutes
     * @deprecated
     */
    metricFailed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (deprecated) Metric for the number of times the heartbeat times out for this activity.
     *
     * @default sum over 5 minutes
     * @deprecated
     */
    metricHeartbeatTimedOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (deprecated) Called whenever this state is bound to a graph.
     *
     * Can be overridden by subclasses.
     *
     * @deprecated
     */
    protected whenBoundToGraph(graph: StateGraph): void;
    private taskMetric;
}
