import * as cdk from "../../../core";
import { IConstruct, Construct } from 'constructs';
import { Condition } from '../condition';
import { StateGraph } from '../state-graph';
import { CatchProps, IChainable, INextable, RetryProps } from '../types';
/**
 * (experimental) Properties shared by all states.
 *
 * @experimental
 */
export interface StateProps {
    /**
     * (experimental) A comment describing this state.
     *
     * @default No comment
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) JSONPath expression to select part of the state to be the input to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * input to be the empty object {}.
     *
     * @default $
     * @experimental
     */
    readonly inputPath?: string;
    /**
     * (experimental) Parameters pass a collection of key-value pairs, either static values or JSONPath expressions that select from the input.
     *
     * @default No parameters
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters
     * @experimental
     */
    readonly parameters?: {
        [name: string]: any;
    };
    /**
     * (experimental) JSONPath expression to select part of the state to be the output to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * output to be the empty object {}.
     *
     * @default $
     * @experimental
     */
    readonly outputPath?: string;
    /**
     * (experimental) JSONPath expression to indicate where to inject the state's output.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the state's
     * input to become its output.
     *
     * @default $
     * @experimental
     */
    readonly resultPath?: string;
}
/**
 * (experimental) Base class for all other state classes.
 *
 * @experimental
 */
export declare abstract class State extends cdk.Construct implements IChainable {
    /**
     * (experimental) Add a prefix to the stateId of all States found in a construct tree.
     *
     * @experimental
     */
    static prefixStates(root: IConstruct, prefix: string): void;
    /**
     * (experimental) Find the set of states reachable through transitions from the given start state.
     *
     * This does not retrieve states from within sub-graphs, such as states within a Parallel state's branch.
     *
     * @experimental
     */
    static findReachableStates(start: State, options?: FindStateOptions): State[];
    /**
     * (experimental) Find the set of end states states reachable through transitions from the given start state.
     *
     * @experimental
     */
    static findReachableEndStates(start: State, options?: FindStateOptions): State[];
    /**
     * (experimental) Return only the states that allow chaining from an array of states.
     *
     * @experimental
     */
    static filterNextables(states: State[]): INextable[];
    /**
     * (experimental) First state of this Chainable.
     *
     * @experimental
     */
    readonly startState: State;
    /**
     * (experimental) Continuable states of this Chainable.
     *
     * @experimental
     */
    abstract readonly endStates: INextable[];
    /**
     * @experimental
     */
    protected readonly comment?: string;
    /**
     * @experimental
     */
    protected readonly inputPath?: string;
    /**
     * @experimental
     */
    protected readonly parameters?: object;
    /**
     * @experimental
     */
    protected readonly outputPath?: string;
    /**
     * @experimental
     */
    protected readonly resultPath?: string;
    /**
     * @experimental
     */
    protected readonly branches: StateGraph[];
    /**
     * @experimental
     */
    protected iteration?: StateGraph;
    /**
     * @experimental
     */
    protected defaultChoice?: State;
    /**
     * @internal
     */
    protected _next?: State;
    private readonly retries;
    private readonly catches;
    private readonly choices;
    private readonly prefixes;
    /**
     * The graph that this state is part of.
     *
     * Used for guaranteeing consistency between graphs and graph components.
     */
    private containingGraph?;
    /**
     * States with references to this state.
     *
     * Used for finding complete connected graph that a state is part of.
     */
    private readonly incomingStates;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: StateProps);
    /**
     * (experimental) Descriptive identifier for this chainable.
     *
     * @experimental
     */
    get id(): string;
    /**
     * (experimental) Tokenized string that evaluates to the state's ID.
     *
     * @experimental
     */
    get stateId(): string;
    /**
     * (experimental) Add a prefix to the stateId of this state.
     *
     * @experimental
     */
    addPrefix(x: string): void;
    /**
     * (experimental) Register this state as part of the given graph.
     *
     * Don't call this. It will be called automatically when you work
     * with states normally.
     *
     * @experimental
     */
    bindToGraph(graph: StateGraph): void;
    /**
     * (experimental) Render the state as JSON.
     *
     * @experimental
     */
    abstract toStateJson(): object;
    /**
     * Add a retrier to the retry list of this state
     * @internal
     */
    protected _addRetry(props?: RetryProps): void;
    /**
     * Add an error handler to the catch list of this state
     * @internal
     */
    protected _addCatch(handler: State, props?: CatchProps): void;
    /**
     * (experimental) Make the indicated state the default transition of this state.
     *
     * @experimental
     */
    protected makeNext(next: State): void;
    /**
     * (experimental) Add a choice branch to this state.
     *
     * @experimental
     */
    protected addChoice(condition: Condition, next: State): void;
    /**
     * (experimental) Add a paralle branch to this state.
     *
     * @experimental
     */
    protected addBranch(branch: StateGraph): void;
    /**
     * (experimental) Add a map iterator to this state.
     *
     * @experimental
     */
    protected addIterator(iteration: StateGraph): void;
    /**
     * (experimental) Make the indicated state the default choice transition of this state.
     *
     * @experimental
     */
    protected makeDefault(def: State): void;
    /**
     * (experimental) Render the default next state in ASL JSON format.
     *
     * @experimental
     */
    protected renderNextEnd(): any;
    /**
     * (experimental) Render the choices in ASL JSON format.
     *
     * @experimental
     */
    protected renderChoices(): any;
    /**
     * (experimental) Render InputPath/Parameters/OutputPath in ASL JSON format.
     *
     * @experimental
     */
    protected renderInputOutput(): any;
    /**
     * (experimental) Render parallel branches in ASL JSON format.
     *
     * @experimental
     */
    protected renderBranches(): any;
    /**
     * (experimental) Render map iterator in ASL JSON format.
     *
     * @experimental
     */
    protected renderIterator(): any;
    /**
     * (experimental) Render error recovery options in ASL JSON format.
     *
     * @experimental
     */
    protected renderRetryCatch(): any;
    /**
     * (experimental) Called whenever this state is bound to a graph.
     *
     * Can be overridden by subclasses.
     *
     * @experimental
     */
    protected whenBoundToGraph(graph: StateGraph): void;
    /**
     * Add a state to the incoming list
     */
    private addIncoming;
    /**
     * Return all states this state can transition to
     */
    private outgoingTransitions;
}
/**
 * (experimental) Options for finding reachable states.
 *
 * @experimental
 */
export interface FindStateOptions {
    /**
     * (experimental) Whether or not to follow error-handling transitions.
     *
     * @default false
     * @experimental
     */
    readonly includeErrorHandlers?: boolean;
}
/**
 * Render a list or return undefined for an empty list
 */
export declare function renderList<T>(xs: T[], mapFn: (x: T) => any, sortFn?: (a: T, b: T) => number): any;
/**
 * Render JSON path, respecting the special value DISCARD
 */
export declare function renderJsonPath(jsonPath?: string): undefined | null | string;
