import { Construct } from 'constructs';
import { Chain } from '../chain';
import { Condition } from '../condition';
import { IChainable, INextable } from '../types';
import { State } from './state';
/**
 * (experimental) Properties for defining a Choice state.
 *
 * @experimental
 */
export interface ChoiceProps {
    /**
     * (experimental) An optional description for this state.
     *
     * @default No comment
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) JSONPath expression to select part of the state to be the input to this state.
     *
     * May also be the special value DISCARD, which will cause the effective
     * input to be the empty object {}.
     *
     * @default $
     * @experimental
     */
    readonly inputPath?: string;
    /**
     * (experimental) JSONPath expression to select part of the state to be the output to this state.
     *
     * May also be the special value DISCARD, which will cause the effective
     * output to be the empty object {}.
     *
     * @default $
     * @experimental
     */
    readonly outputPath?: string;
}
/**
 * (experimental) Define a Choice in the state machine.
 *
 * A choice state can be used to make decisions based on the execution
 * state.
 *
 * @experimental
 */
export declare class Choice extends State {
    /**
     * (experimental) Continuable states of this Chainable.
     *
     * @experimental
     */
    readonly endStates: INextable[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ChoiceProps);
    /**
     * (experimental) If the given condition matches, continue execution with the given state.
     *
     * @experimental
     */
    when(condition: Condition, next: IChainable): Choice;
    /**
     * (experimental) If none of the given conditions match, continue execution with the given state.
     *
     * If no conditions match and no otherwise() has been given, an execution
     * error will be raised.
     *
     * @experimental
     */
    otherwise(def: IChainable): Choice;
    /**
     * (experimental) Return a Chain that contains all reachable end states from this Choice.
     *
     * Use this to combine all possible choice paths back.
     *
     * @experimental
     */
    afterwards(options?: AfterwardsOptions): Chain;
    /**
     * (experimental) Return the Amazon States Language object for this state.
     *
     * @experimental
     */
    toStateJson(): object;
}
/**
 * (experimental) Options for selecting the choice paths.
 *
 * @experimental
 */
export interface AfterwardsOptions {
    /**
     * (experimental) Whether to include error handling states.
     *
     * If this is true, all states which are error handlers (added through 'onError')
     * and states reachable via error handlers will be included as well.
     *
     * @default false
     * @experimental
     */
    readonly includeErrorHandlers?: boolean;
    /**
     * (experimental) Whether to include the default/otherwise transition for the current Choice state.
     *
     * If this is true and the current Choice does not have a default outgoing
     * transition, one will be added included when .next() is called on the chain.
     *
     * @default false
     * @experimental
     */
    readonly includeOtherwise?: boolean;
}
