import * as iam from "../../aws-iam";
import { Duration } from "../../core";
import { State } from './states/state';
/**
 * (experimental) A collection of connected states.
 *
 * A StateGraph is used to keep track of all states that are connected (have
 * transitions between them). It does not include the substatemachines in
 * a Parallel's branches: those are their own StateGraphs, but the graphs
 * themselves have a hierarchical relationship as well.
 *
 * By assigning states to a definitive StateGraph, we verify that no state
 * machines are constructed. In particular:
 *
 * - Every state object can only ever be in 1 StateGraph, and not inadvertently
 *    be used in two graphs.
 * - Every stateId must be unique across all states in the entire state
 *    machine.
 *
 * All policy statements in all states in all substatemachines are bubbled so
 * that the top-level StateMachine instantiation can read them all and add
 * them to the IAM Role.
 *
 * You do not need to instantiate this class; it is used internally.
 *
 * @experimental
 */
export declare class StateGraph {
    readonly startState: State;
    private readonly graphDescription;
    /**
     * (experimental) Set a timeout to render into the graph JSON.
     *
     * Read/write. Only makes sense on the top-level graph, subgraphs
     * do not support this feature.
     *
     * @default No timeout
     * @experimental
     */
    timeout?: Duration;
    /**
     * (experimental) The accumulated policy statements.
     *
     * @experimental
     */
    readonly policyStatements: iam.PolicyStatement[];
    /**
     * All states in this graph
     */
    private readonly allStates;
    /**
     * A mapping of stateId -> Graph for all states in this graph and subgraphs
     */
    private readonly allContainedStates;
    /**
     * Containing graph of this graph
     */
    private superGraph?;
    /**
     * @param startState state that gets executed when the state machine is launched.
     * @param graphDescription description of the state machine.
     * @experimental
     */
    constructor(startState: State, graphDescription: string);
    /**
     * (experimental) Register a state as part of this graph.
     *
     * Called by State.bindToGraph().
     *
     * @experimental
     */
    registerState(state: State): void;
    /**
     * (experimental) Register a Policy Statement used by states in this graph.
     *
     * @experimental
     */
    registerPolicyStatement(statement: iam.PolicyStatement): void;
    /**
     * (experimental) Register this graph as a child of the given graph.
     *
     * Resource changes will be bubbled up to the given graph.
     *
     * @experimental
     */
    registerSuperGraph(graph: StateGraph): void;
    /**
     * (experimental) Return the Amazon States Language JSON for this graph.
     *
     * @experimental
     */
    toGraphJson(): object;
    /**
     * (experimental) Return a string description of this graph.
     *
     * @experimental
     */
    toString(): string;
    /**
     * Register a stateId and graph where it was registered
     */
    private registerContainedState;
    /**
     * Push all contained state info up to the given super graph
     */
    private pushContainedStatesUp;
    /**
     * Push all policy statements to into the given super graph
     */
    private pushPolicyStatementsUp;
}
