/**
 * (experimental) A Condition for use in a Choice state branch.
 *
 * @experimental
 */
export declare abstract class Condition {
    /**
     * (experimental) Matches if variable is present.
     *
     * @experimental
     */
    static isPresent(variable: string): Condition;
    /**
     * (experimental) Matches if variable is not present.
     *
     * @experimental
     */
    static isNotPresent(variable: string): Condition;
    /**
     * (experimental) Matches if variable is a string.
     *
     * @experimental
     */
    static isString(variable: string): Condition;
    /**
     * (experimental) Matches if variable is not a string.
     *
     * @experimental
     */
    static isNotString(variable: string): Condition;
    /**
     * (experimental) Matches if variable is numeric.
     *
     * @experimental
     */
    static isNumeric(variable: string): Condition;
    /**
     * (experimental) Matches if variable is not numeric.
     *
     * @experimental
     */
    static isNotNumeric(variable: string): Condition;
    /**
     * (experimental) Matches if variable is boolean.
     *
     * @experimental
     */
    static isBoolean(variable: string): Condition;
    /**
     * (experimental) Matches if variable is not boolean.
     *
     * @experimental
     */
    static isNotBoolean(variable: string): Condition;
    /**
     * (experimental) Matches if variable is a timestamp.
     *
     * @experimental
     */
    static isTimestamp(variable: string): Condition;
    /**
     * (experimental) Matches if variable is not a timestamp.
     *
     * @experimental
     */
    static isNotTimestamp(variable: string): Condition;
    /**
     * (experimental) Matches if variable is not null.
     *
     * @experimental
     */
    static isNotNull(variable: string): Condition;
    /**
     * (experimental) Matches if variable is Null.
     *
     * @experimental
     */
    static isNull(variable: string): Condition;
    /**
     * (experimental) Matches if a boolean field has the given value.
     *
     * @experimental
     */
    static booleanEquals(variable: string, value: boolean): Condition;
    /**
     * (experimental) Matches if a boolean field equals to a value at a given mapping path.
     *
     * @experimental
     */
    static booleanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a string field equals to a value at a given mapping path.
     *
     * @experimental
     */
    static stringEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a string field has the given value.
     *
     * @experimental
     */
    static stringEquals(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a string field sorts before a given value.
     *
     * @experimental
     */
    static stringLessThan(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a string field sorts before a given value at a particular mapping.
     *
     * @experimental
     */
    static stringLessThanJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a string field sorts equal to or before a given value.
     *
     * @experimental
     */
    static stringLessThanEquals(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a string field sorts equal to or before a given mapping.
     *
     * @experimental
     */
    static stringLessThanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a string field sorts after a given value.
     *
     * @experimental
     */
    static stringGreaterThan(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a string field sorts after a value at a given mapping path.
     *
     * @experimental
     */
    static stringGreaterThanJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a string field sorts after or equal to value at a given mapping path.
     *
     * @experimental
     */
    static stringGreaterThanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a string field sorts after or equal to a given value.
     *
     * @experimental
     */
    static stringGreaterThanEquals(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a numeric field has the given value.
     *
     * @experimental
     */
    static numberEquals(variable: string, value: number): Condition;
    /**
     * (experimental) Matches if a numeric field has the value in a given mapping path.
     *
     * @experimental
     */
    static numberEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a numeric field is less than the given value.
     *
     * @experimental
     */
    static numberLessThan(variable: string, value: number): Condition;
    /**
     * (experimental) Matches if a numeric field is less than the value at the given mapping path.
     *
     * @experimental
     */
    static numberLessThanJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a numeric field is less than or equal to the given value.
     *
     * @experimental
     */
    static numberLessThanEquals(variable: string, value: number): Condition;
    /**
     * (experimental) Matches if a numeric field is less than or equal to the numeric value at given mapping path.
     *
     * @experimental
     */
    static numberLessThanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a numeric field is greater than the given value.
     *
     * @experimental
     */
    static numberGreaterThan(variable: string, value: number): Condition;
    /**
     * (experimental) Matches if a numeric field is greater than the value at a given mapping path.
     *
     * @experimental
     */
    static numberGreaterThanJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a numeric field is greater than or equal to the given value.
     *
     * @experimental
     */
    static numberGreaterThanEquals(variable: string, value: number): Condition;
    /**
     * (experimental) Matches if a numeric field is greater than or equal to the value at a given mapping path.
     *
     * @experimental
     */
    static numberGreaterThanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a timestamp field is the same time as the given timestamp.
     *
     * @experimental
     */
    static timestampEquals(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a timestamp field is the same time as the timestamp at a given mapping path.
     *
     * @experimental
     */
    static timestampEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a timestamp field is before the given timestamp.
     *
     * @experimental
     */
    static timestampLessThan(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a timestamp field is before the timestamp at a given mapping path.
     *
     * @experimental
     */
    static timestampLessThanJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a timestamp field is before or equal to the given timestamp.
     *
     * @experimental
     */
    static timestampLessThanEquals(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a timestamp field is before or equal to the timestamp at a given mapping path.
     *
     * @experimental
     */
    static timestampLessThanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a timestamp field is after the given timestamp.
     *
     * @experimental
     */
    static timestampGreaterThan(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a timestamp field is after the timestamp at a given mapping path.
     *
     * @experimental
     */
    static timestampGreaterThanJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a timestamp field is after or equal to the given timestamp.
     *
     * @experimental
     */
    static timestampGreaterThanEquals(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a timestamp field is after or equal to the timestamp at a given mapping path.
     *
     * @experimental
     */
    static timestampGreaterThanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * (experimental) Matches if a field matches a string pattern that can contain a wild card (*) e.g: log-*.txt or *LATEST*. No other characters other than "*" have any special meaning - * can be escaped: \\*.
     *
     * @experimental
     */
    static stringMatches(variable: string, value: string): Condition;
    /**
     * (experimental) Combine two or more conditions with a logical AND.
     *
     * @experimental
     */
    static and(...conditions: Condition[]): Condition;
    /**
     * (experimental) Combine two or more conditions with a logical OR.
     *
     * @experimental
     */
    static or(...conditions: Condition[]): Condition;
    /**
     * (experimental) Negate a condition.
     *
     * @experimental
     */
    static not(condition: Condition): Condition;
    /**
     * (experimental) Render Amazon States Language JSON for the condition.
     *
     * @experimental
     */
    abstract renderCondition(): any;
}
