"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsInvokeActivity = void 0;
const sfn = require("../../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
/**
 * (experimental) A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 *
 * @experimental
 */
class StepFunctionsInvokeActivity extends sfn.TaskStateBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.taskMetrics = {
            metricDimensions: { ActivityArn: this.props.activity.activityArn },
            metricPrefixSingular: 'Activity',
            metricPrefixPlural: 'Activities',
        };
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: this.props.activity.activityArn,
        };
    }
}
exports.StepFunctionsInvokeActivity = StepFunctionsInvokeActivity;
//# sourceMappingURL=data:application/json;base64,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