import * as ec2 from "../../../aws-ec2";
import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
import { IContainerDefinition } from './base-types';
/**
 * (experimental) Properties for creating an Amazon SageMaker model.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 * @experimental
 */
export interface SageMakerCreateModelProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) An execution role that you can pass in a CreateModel API request.
     *
     * @default - a role will be created.
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) The name of the new model.
     *
     * @experimental
     */
    readonly modelName: string;
    /**
     * (experimental) The definition of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions.
     *
     * @experimental
     */
    readonly primaryContainer: IContainerDefinition;
    /**
     * (experimental) Specifies the containers in the inference pipeline.
     *
     * @default - None
     * @experimental
     */
    readonly containers?: IContainerDefinition[];
    /**
     * (experimental) Isolates the model container.
     *
     * No inbound or outbound network calls can be made to or from the model container.
     *
     * @default false
     * @experimental
     */
    readonly enableNetworkIsolation?: boolean;
    /**
     * (experimental) The VPC that is accessible by the hosted model.
     *
     * @default - None
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) The subnets of the VPC to which the hosted model is connected (Note this parameter is only used when VPC is provided).
     *
     * @default - Private Subnets are selected
     * @experimental
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * (experimental) Tags to be applied to the model.
     *
     * @default - No tags
     * @experimental
     */
    readonly tags?: sfn.TaskInput;
}
/**
 * (experimental) A Step Functions Task to create a SageMaker model.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 * @experimental
 */
export declare class SageMakerCreateModel extends sfn.TaskStateBase implements iam.IGrantable, ec2.IConnectable {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * (experimental) Allows specify security group connections for instances of this fleet.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) The execution role for the Sagemaker Create Model API.
     *
     * @experimental
     */
    readonly role: iam.IRole;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: iam.IPrincipal;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly vpc?;
    private securityGroup?;
    private readonly securityGroups;
    private readonly subnets?;
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SageMakerCreateModelProps);
    /**
     * (experimental) Add the security group to all instances via the launch configuration security groups array.
     *
     * @param securityGroup : The security group to add.
     * @experimental
     */
    addSecurityGroup(securityGroup: ec2.ISecurityGroup): void;
    /**
     * @internal
     */
    protected _renderTask(): any;
    private renderParameters;
    private makePolicyStatements;
    private createSagemakerRole;
    private renderVpcConfig;
}
