import * as iam from "../../../aws-iam";
import * as lambda from "../../../aws-lambda";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
/**
 * (experimental) Properties for invoking a Lambda function with LambdaInvoke.
 *
 * @experimental
 */
export interface LambdaInvokeProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) Lambda function to invoke.
     *
     * @experimental
     */
    readonly lambdaFunction: lambda.IFunction;
    /**
     * (experimental) The JSON that will be supplied as input to the Lambda function.
     *
     * @default - The state input (JSON path '$')
     * @experimental
     */
    readonly payload?: sfn.TaskInput;
    /**
     * (experimental) Invocation type of the Lambda function.
     *
     * @default InvocationType.REQUEST_RESPONSE
     * @experimental
     */
    readonly invocationType?: LambdaInvocationType;
    /**
     * (experimental) Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function.
     *
     * @default - No context
     * @experimental
     */
    readonly clientContext?: string;
    /**
     * (experimental) Version or alias to invoke a published version of the function.
     *
     * You only need to supply this if you want the version of the Lambda Function to depend
     * on data in the state machine state. If not, you can pass the appropriate Alias or Version object
     * directly as the `lambdaFunction` argument.
     *
     * @default - Version or alias inherent to the `lambdaFunction` object.
     * @experimental
     */
    readonly qualifier?: string;
    /**
     * (experimental) Invoke the Lambda in a way that only returns the payload response without additional metadata.
     *
     * The `payloadResponseOnly` property cannot be used if `integrationPattern`, `invocationType`,
     * `clientContext`, or `qualifier` are specified.
     * It always uses the REQUEST_RESPONSE behavior.
     *
     * @default false
     * @experimental
     */
    readonly payloadResponseOnly?: boolean;
    /**
     * (experimental) Whether to retry on Lambda service exceptions.
     *
     * This handles `Lambda.ServiceException`, `Lambda.AWSLambdaException` and
     * `Lambda.SdkClientException` with an interval of 2 seconds, a back-off rate
     * of 2 and 6 maximum attempts.
     *
     * @default true
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/bp-lambda-serviceexception.html
     * @experimental
     */
    readonly retryOnServiceExceptions?: boolean;
}
/**
 * (experimental) Invoke a Lambda function as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-lambda.html
 * @experimental
 */
export declare class LambdaInvoke extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: LambdaInvokeProps);
    /**
     * Provides the Lambda Invoke service integration task configuration
     */
    /**
     * @internal
     */
    protected _renderTask(): any;
}
/**
 * (experimental) Invocation type of a Lambda.
 *
 * @experimental
 */
export declare enum LambdaInvocationType {
    /**
     * (experimental) Invoke the function synchronously.
     *
     * Keep the connection open until the function returns a response or times out.
     * The API response includes the function response and additional data.
     *
     * @experimental
     */
    REQUEST_RESPONSE = "RequestResponse",
    /**
     * (experimental) Invoke the function asynchronously.
     *
     * Send events that fail multiple times to the function's dead-letter queue (if it's configured).
     * The API response only includes a status code.
     *
     * @experimental
     */
    EVENT = "Event",
    /**
     * (experimental) Validate parameter values and verify that the user or role has permission to invoke the function.
     *
     * @experimental
     */
    DRY_RUN = "DryRun"
}
