import * as ec2 from "../../../aws-ec2";
import * as ecs from "../../../aws-ecs";
import * as sfn from "../../../aws-stepfunctions";
import { ContainerOverride } from './run-ecs-task-base-types';
/**
 * (experimental) Basic properties for ECS Tasks.
 *
 * @experimental
 */
export interface CommonEcsRunTaskProps {
    /**
     * (experimental) The topic to run the task on.
     *
     * @experimental
     */
    readonly cluster: ecs.ICluster;
    /**
     * (experimental) Task Definition used for running tasks in the service.
     *
     * Note: this must be TaskDefinition, and not ITaskDefinition,
     * as it requires properties that are not known for imported task definitions
     *
     * @experimental
     */
    readonly taskDefinition: ecs.TaskDefinition;
    /**
     * (experimental) Container setting overrides.
     *
     * Key is the name of the container to override, value is the
     * values you want to override.
     *
     * @default - No overrides
     * @experimental
     */
    readonly containerOverrides?: ContainerOverride[];
    /**
     * (experimental) The service integration pattern indicates different ways to call RunTask in ECS.
     *
     * The valid value for Lambda is FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN.
     *
     * @default FIRE_AND_FORGET
     * @experimental
     */
    readonly integrationPattern?: sfn.ServiceIntegrationPattern;
}
/**
 * (experimental) Construction properties for the BaseRunTaskProps.
 *
 * @experimental
 */
export interface EcsRunTaskBaseProps extends CommonEcsRunTaskProps {
    /**
     * (experimental) Additional parameters to pass to the base task.
     *
     * @default - No additional parameters passed
     * @experimental
     */
    readonly parameters?: {
        [key: string]: any;
    };
}
/**
 * (experimental) A StepFunctions Task to run a Task on ECS or Fargate.
 *
 * @experimental
 */
export declare class EcsRunTaskBase implements ec2.IConnectable, sfn.IStepFunctionsTask {
    private readonly props;
    /**
     * (experimental) Manage allowed network traffic for this service.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    private securityGroup?;
    private networkConfiguration?;
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(props: EcsRunTaskBaseProps);
    /**
     * (experimental) Called when the task object is used in a workflow.
     *
     * @experimental
     */
    bind(task: sfn.Task): sfn.StepFunctionsTaskConfig;
    /**
     * @experimental
     */
    protected configureAwsVpcNetworking(vpc: ec2.IVpc, assignPublicIp?: boolean, subnetSelection?: ec2.SubnetSelection, securityGroup?: ec2.ISecurityGroup): void;
    private makePolicyStatements;
    private taskExecutionRoles;
}
