import * as ec2 from "../../../aws-ec2";
import * as ecs from "../../../aws-ecs";
import { CommonEcsRunTaskProps, EcsRunTaskBase } from './run-ecs-task-base';
/**
 * (experimental) Properties to run an ECS task on EC2 in StepFunctionsan ECS.
 *
 * @experimental
 */
export interface RunEcsEc2TaskProps extends CommonEcsRunTaskProps {
    /**
     * (experimental) In what subnets to place the task's ENIs.
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default Private subnets
     * @experimental
     */
    readonly subnets?: ec2.SubnetSelection;
    /**
     * (experimental) Existing security group to use for the task's ENIs.
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default A new security group is created
     * @experimental
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) Placement constraints.
     *
     * @default No constraints
     * @experimental
     */
    readonly placementConstraints?: ecs.PlacementConstraint[];
    /**
     * (experimental) Placement strategies.
     *
     * @default No strategies
     * @experimental
     */
    readonly placementStrategies?: ecs.PlacementStrategy[];
}
/**
 * (deprecated) Run an ECS/EC2 Task in a StepFunctions workflow.
 *
 * @deprecated - replaced by `EcsEc2RunTask`
 */
export declare class RunEcsEc2Task extends EcsRunTaskBase {
    /**
     * @deprecated
     */
    constructor(props: RunEcsEc2TaskProps);
}
