import * as ddb from "../../../aws-dynamodb";
import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
import { DynamoAttributeValue, DynamoConsumedCapacity, DynamoProjectionExpression } from './shared-types';
/**
 * (experimental) Properties for DynamoGetItem Task.
 *
 * @experimental
 */
export interface DynamoGetItemProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The name of the table containing the requested item.
     *
     * @experimental
     */
    readonly table: ddb.ITable;
    /**
     * (experimental) Primary key of the item to retrieve.
     *
     * For the primary key, you must provide all of the attributes.
     * For example, with a simple primary key, you only need to provide a value for the partition key.
     * For a composite primary key, you must provide values for both the partition key and the sort key.
     *
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-Key
     * @experimental
     */
    readonly key: {
        [key: string]: DynamoAttributeValue;
    };
    /**
     * (experimental) Determines the read consistency model: If set to true, then the operation uses strongly consistent reads;
     *
     * otherwise, the operation uses eventually consistent reads.
     *
     * @default false
     * @experimental
     */
    readonly consistentRead?: boolean;
    /**
     * (experimental) One or more substitution tokens for attribute names in an expression.
     *
     * @default - No expression attributes
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-ExpressionAttributeNames
     * @experimental
     */
    readonly expressionAttributeNames?: {
        [key: string]: string;
    };
    /**
     * (experimental) An array of DynamoProjectionExpression that identifies one or more attributes to retrieve from the table.
     *
     * These attributes can include scalars, sets, or elements of a JSON document.
     *
     * @default - No projection expression
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-ProjectionExpression
     * @experimental
     */
    readonly projectionExpression?: DynamoProjectionExpression[];
    /**
     * (experimental) Determines the level of detail about provisioned throughput consumption that is returned in the response.
     *
     * @default DynamoConsumedCapacity.NONE
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-ReturnConsumedCapacity
     * @experimental
     */
    readonly returnConsumedCapacity?: DynamoConsumedCapacity;
}
/**
 * (experimental) A StepFunctions task to call DynamoGetItem.
 *
 * @experimental
 */
export declare class DynamoGetItem extends sfn.TaskStateBase {
    private readonly props;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DynamoGetItemProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
    private configureProjectionExpression;
}
