"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncryptionOption = exports.AthenaStartQueryExecution = void 0;
const iam = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const sfn = require("../../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const task_utils_1 = require("../private/task-utils");
/**
 * (experimental) Start an Athena Query as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-athena.html
 * @experimental
 */
class AthenaStartQueryExecution extends sfn.TaskStateBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id, props);
        this.props = props;
        this.integrationPattern = (_a = props.integrationPattern) !== null && _a !== void 0 ? _a : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, AthenaStartQueryExecution.SUPPORTED_INTEGRATION_PATTERNS);
        this.taskPolicies = this.createPolicyStatements();
    }
    createPolicyStatements() {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        const policyStatements = [
            new iam.PolicyStatement({
                resources: [
                    cdk.Stack.of(this).formatArn({
                        service: 'athena',
                        resource: 'datacatalog',
                        resourceName: (_b = (_a = this.props.queryExecutionContext) === null || _a === void 0 ? void 0 : _a.catalogName) !== null && _b !== void 0 ? _b : 'AwsDataCatalog',
                    }),
                    cdk.Stack.of(this).formatArn({
                        service: 'athena',
                        resource: 'workgroup',
                        resourceName: (_c = this.props.workGroup) !== null && _c !== void 0 ? _c : 'primary',
                    }),
                ],
                actions: ['athena:getDataCatalog', 'athena:startQueryExecution', 'athena:getQueryExecution'],
            }),
        ];
        policyStatements.push(new iam.PolicyStatement({
            actions: ['s3:CreateBucket',
                's3:ListBucket',
                's3:GetBucketLocation',
                's3:GetObject'],
            resources: ['*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['s3:AbortMultipartUpload',
                's3:ListBucketMultipartUploads',
                's3:ListMultipartUploadParts',
                's3:PutObject'],
            resources: [((_e = (_d = this.props.resultConfiguration) === null || _d === void 0 ? void 0 : _d.outputLocation) === null || _e === void 0 ? void 0 : _e.bucketName) ? `arn:aws:s3:::${(_g = (_f = this.props.resultConfiguration) === null || _f === void 0 ? void 0 : _f.outputLocation) === null || _g === void 0 ? void 0 : _g.bucketName}/${(_j = (_h = this.props.resultConfiguration) === null || _h === void 0 ? void 0 : _h.outputLocation) === null || _j === void 0 ? void 0 : _j.objectKey}/*` : '*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['lakeformation:GetDataAccess'],
            resources: ['*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['glue:BatchCreatePartition',
                'glue:BatchDeletePartition',
                'glue:BatchDeleteTable',
                'glue:BatchGetPartition',
                'glue:CreateDatabase',
                'glue:CreatePartition',
                'glue:CreateTable',
                'glue:DeleteDatabase',
                'glue:DeletePartition',
                'glue:DeleteTable',
                'glue:GetDatabase',
                'glue:GetDatabases',
                'glue:GetPartition',
                'glue:GetPartitions',
                'glue:GetTable',
                'glue:GetTables',
                'glue:UpdateDatabase',
                'glue:UpdatePartition',
                'glue:UpdateTable'],
            resources: [
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'catalog',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'database',
                    resourceName: (_l = (_k = this.props.queryExecutionContext) === null || _k === void 0 ? void 0 : _k.databaseName) !== null && _l !== void 0 ? _l : 'default',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'table',
                    resourceName: ((_o = (_m = this.props.queryExecutionContext) === null || _m === void 0 ? void 0 : _m.databaseName) !== null && _o !== void 0 ? _o : 'default') + '/*',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'userdefinedfunction',
                    resourceName: ((_q = (_p = this.props.queryExecutionContext) === null || _p === void 0 ? void 0 : _p.databaseName) !== null && _q !== void 0 ? _q : 'default') + '/*',
                }),
            ],
        }));
        return policyStatements;
    }
    /**
     * Provides the Athena start query execution service integration task configuration
     */
    /**
     * @internal
     */
    _renderTask() {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
        if ((_a = this.props.resultConfiguration) === null || _a === void 0 ? void 0 : _a.outputLocation) {
            return {
                Resource: task_utils_1.integrationResourceArn('athena', 'startQueryExecution', this.integrationPattern),
                Parameters: sfn.FieldUtils.renderObject({
                    QueryString: this.props.queryString,
                    ClientRequestToken: this.props.clientRequestToken,
                    QueryExecutionContext: {
                        Catalog: (_b = this.props.queryExecutionContext) === null || _b === void 0 ? void 0 : _b.catalogName,
                        Database: (_c = this.props.queryExecutionContext) === null || _c === void 0 ? void 0 : _c.databaseName,
                    },
                    ResultConfiguration: {
                        EncryptionConfiguration: {
                            EncryptionOption: (_e = (_d = this.props.resultConfiguration) === null || _d === void 0 ? void 0 : _d.encryptionConfiguration) === null || _e === void 0 ? void 0 : _e.encryptionOption,
                            KmsKey: (_g = (_f = this.props.resultConfiguration) === null || _f === void 0 ? void 0 : _f.encryptionConfiguration) === null || _g === void 0 ? void 0 : _g.encryptionKey,
                        },
                        OutputLocation: `s3://${(_j = (_h = this.props.resultConfiguration) === null || _h === void 0 ? void 0 : _h.outputLocation) === null || _j === void 0 ? void 0 : _j.bucketName}/${(_l = (_k = this.props.resultConfiguration) === null || _k === void 0 ? void 0 : _k.outputLocation) === null || _l === void 0 ? void 0 : _l.objectKey}/`,
                    },
                    WorkGroup: this.props.workGroup,
                }),
            };
        }
        else {
            return {
                Resource: task_utils_1.integrationResourceArn('athena', 'startQueryExecution', this.integrationPattern),
                Parameters: sfn.FieldUtils.renderObject({
                    QueryString: this.props.queryString,
                    ClientRequestToken: this.props.clientRequestToken,
                    QueryExecutionContext: {
                        Catalog: (_m = this.props.queryExecutionContext) === null || _m === void 0 ? void 0 : _m.catalogName,
                        Database: (_o = this.props.queryExecutionContext) === null || _o === void 0 ? void 0 : _o.databaseName,
                    },
                    ResultConfiguration: {
                        EncryptionConfiguration: {
                            EncryptionOption: (_q = (_p = this.props.resultConfiguration) === null || _p === void 0 ? void 0 : _p.encryptionConfiguration) === null || _q === void 0 ? void 0 : _q.encryptionOption,
                            KmsKey: (_s = (_r = this.props.resultConfiguration) === null || _r === void 0 ? void 0 : _r.encryptionConfiguration) === null || _s === void 0 ? void 0 : _s.encryptionKey,
                        },
                    },
                    WorkGroup: this.props.workGroup,
                }),
            };
        }
    }
}
exports.AthenaStartQueryExecution = AthenaStartQueryExecution;
AthenaStartQueryExecution.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.RUN_JOB,
];
/**
 * (experimental) Encryption Options of the S3 bucket.
 *
 * @see https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html#athena-Type-EncryptionConfiguration-EncryptionOption
 * @experimental
 */
var EncryptionOption;
(function (EncryptionOption) {
    EncryptionOption["S3_MANAGED"] = "SSE_S3";
    EncryptionOption["KMS"] = "SSE_KMS";
    EncryptionOption["CLIENT_SIDE_KMS"] = "CSE_KMS";
})(EncryptionOption = exports.EncryptionOption || (exports.EncryptionOption = {}));
//# sourceMappingURL=data:application/json;base64,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