import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
/**
 * (experimental) Properties for getting a Query Results.
 *
 * @experimental
 */
export interface AthenaGetQueryResultsProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) Query that will be retrieved.
     *
     * @experimental
     * @example
     *
     * 'adfsaf-23trf23-f23rt23'
     */
    readonly queryExecutionId: string;
    /**
     * (experimental) Pagination token.
     *
     * @default - No next token
     * @experimental
     */
    readonly nextToken?: string;
    /**
     * (experimental) Max number of results.
     *
     * @default 1000
     * @experimental
     */
    readonly maxResults?: number;
}
/**
 * (experimental) Get an Athena Query Results as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-athena.html
 * @experimental
 */
export declare class AthenaGetQueryResults extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AthenaGetQueryResultsProps);
    /**
     * Provides the Athena get query results service integration task configuration
     * @internal
     */
    protected _renderTask(): any;
}
