import * as iam from "../../aws-iam";
import * as kms from "../../aws-kms";
import { Construct as CompatConstruct, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) An SSM Parameter reference.
 *
 * @experimental
 */
export interface IParameter extends IResource {
    /**
     * (experimental) The ARN of the SSM Parameter resource.
     *
     * @experimental
     * @attribute true
     */
    readonly parameterArn: string;
    /**
     * (experimental) The name of the SSM Parameter resource.
     *
     * @experimental
     * @attribute true
     */
    readonly parameterName: string;
    /**
     * (experimental) The type of the SSM Parameter resource.
     *
     * @experimental
     * @attribute true
     */
    readonly parameterType: string;
    /**
     * (experimental) Grants read (DescribeParameter, GetParameter, GetParameterHistory) permissions on the SSM Parameter.
     *
     * @param grantee the role to be granted read-only access to the parameter.
     * @experimental
     */
    grantRead(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grants write (PutParameter) permissions on the SSM Parameter.
     *
     * @param grantee the role to be granted write access to the parameter.
     * @experimental
     */
    grantWrite(grantee: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) A String SSM Parameter.
 *
 * @experimental
 */
export interface IStringParameter extends IParameter {
    /**
     * (experimental) The parameter value.
     *
     * Value must not nest another parameter. Do not use {{}} in the value.
     *
     * @experimental
     * @attribute Value
     */
    readonly stringValue: string;
}
/**
 * (experimental) A StringList SSM Parameter.
 *
 * @experimental
 */
export interface IStringListParameter extends IParameter {
    /**
     * (experimental) The parameter value.
     *
     * Value must not nest another parameter. Do not use {{}} in the value. Values in the array
     * cannot contain commas (``,``).
     *
     * @experimental
     * @attribute Value
     */
    readonly stringListValue: string[];
}
/**
 * (experimental) Properties needed to create a new SSM Parameter.
 *
 * @experimental
 */
export interface ParameterOptions {
    /**
     * (experimental) A regular expression used to validate the parameter value.
     *
     * For example, for String types with values restricted to
     * numbers, you can specify the following: ``^\d+$``
     *
     * @default no validation is performed
     * @experimental
     */
    readonly allowedPattern?: string;
    /**
     * (experimental) Information about the parameter that you want to add to the system.
     *
     * @default none
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The name of the parameter.
     *
     * @default - a name will be generated by CloudFormation
     * @experimental
     */
    readonly parameterName?: string;
    /**
     * (experimental) Indicates of the parameter name is a simple name (i.e. does not include "/" separators).
     *
     * This is only required only if `parameterName` is a token, which means we
     * are unable to detect if the name is simple or "path-like" for the purpose
     * of rendering SSM parameter ARNs.
     *
     * If `parameterName` is not specified, `simpleName` must be `true` (or
     * undefined) since the name generated by AWS CloudFormation is always a
     * simple name.
     *
     * @default - auto-detect based on `parameterName`
     * @experimental
     */
    readonly simpleName?: boolean;
    /**
     * (experimental) The tier of the string parameter.
     *
     * @default - undefined
     * @experimental
     */
    readonly tier?: ParameterTier;
}
/**
 * (experimental) Properties needed to create a String SSM parameter.
 *
 * @experimental
 */
export interface StringParameterProps extends ParameterOptions {
    /**
     * (experimental) The value of the parameter.
     *
     * It may not reference another parameter and ``{{}}`` cannot be used in the value.
     *
     * @experimental
     */
    readonly stringValue: string;
    /**
     * (experimental) The type of the string parameter.
     *
     * @default ParameterType.STRING
     * @experimental
     */
    readonly type?: ParameterType;
}
/**
 * (experimental) Properties needed to create a StringList SSM Parameter.
 *
 * @experimental
 */
export interface StringListParameterProps extends ParameterOptions {
    /**
     * (experimental) The values of the parameter.
     *
     * It may not reference another parameter and ``{{}}`` cannot be used in the value.
     *
     * @experimental
     */
    readonly stringListValue: string[];
}
/**
 * Basic features shared across all types of SSM Parameters.
 */
declare abstract class ParameterBase extends Resource implements IParameter {
    abstract readonly parameterArn: string;
    abstract readonly parameterName: string;
    abstract readonly parameterType: string;
    /**
     * (experimental) The encryption key that is used to encrypt this parameter.
     *
     * * @default - default master key
     *
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Grants read (DescribeParameter, GetParameter, GetParameterHistory) permissions on the SSM Parameter.
     *
     * @experimental
     */
    grantRead(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grants write (PutParameter) permissions on the SSM Parameter.
     *
     * @experimental
     */
    grantWrite(grantee: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) SSM parameter type.
 *
 * @experimental
 */
export declare enum ParameterType {
    /**
     * (experimental) String.
     *
     * @experimental
     */
    STRING = "String",
    /**
     * (experimental) Secure String Parameter Store uses an AWS Key Management Service (KMS) customer master key (CMK) to encrypt the parameter value.
     *
     * @experimental
     */
    SECURE_STRING = "SecureString",
    /**
     * (experimental) String List.
     *
     * @experimental
     */
    STRING_LIST = "StringList",
    /**
     * (experimental) An Amazon EC2 image ID, such as ami-0ff8a91507f77f867.
     *
     * @experimental
     */
    AWS_EC2_IMAGE_ID = "AWS::EC2::Image::Id"
}
/**
 * (experimental) SSM parameter tier.
 *
 * @experimental
 */
export declare enum ParameterTier {
    /**
     * (experimental) String.
     *
     * @experimental
     */
    ADVANCED = "Advanced",
    /**
     * (experimental) String.
     *
     * @experimental
     */
    INTELLIGENT_TIERING = "Intelligent-Tiering",
    /**
     * (experimental) String.
     *
     * @experimental
     */
    STANDARD = "Standard"
}
/**
 * (experimental) Common attributes for string parameters.
 *
 * @experimental
 */
export interface CommonStringParameterAttributes {
    /**
     * (experimental) The name of the parameter store value.
     *
     * This value can be a token or a concrete string. If it is a concrete string
     * and includes "/" it must also be prefixed with a "/" (fully-qualified).
     *
     * @experimental
     */
    readonly parameterName: string;
    /**
     * (experimental) Indicates of the parameter name is a simple name (i.e. does not include "/" separators).
     *
     * This is only required only if `parameterName` is a token, which means we
     * are unable to detect if the name is simple or "path-like" for the purpose
     * of rendering SSM parameter ARNs.
     *
     * If `parameterName` is not specified, `simpleName` must be `true` (or
     * undefined) since the name generated by AWS CloudFormation is always a
     * simple name.
     *
     * @default - auto-detect based on `parameterName`
     * @experimental
     */
    readonly simpleName?: boolean;
}
/**
 * (experimental) Attributes for parameters of various types of string.
 *
 * @see ParameterType
 * @experimental
 */
export interface StringParameterAttributes extends CommonStringParameterAttributes {
    /**
     * (experimental) The version number of the value you wish to retrieve.
     *
     * @default The latest version will be retrieved.
     * @experimental
     */
    readonly version?: number;
    /**
     * (experimental) The type of the string parameter.
     *
     * @default ParameterType.STRING
     * @experimental
     */
    readonly type?: ParameterType;
}
/**
 * (experimental) Attributes for secure string parameters.
 *
 * @experimental
 */
export interface SecureStringParameterAttributes extends CommonStringParameterAttributes {
    /**
     * (experimental) The version number of the value you wish to retrieve.
     *
     * This is required for secure strings.
     *
     * @experimental
     */
    readonly version: number;
    /**
     * (experimental) The encryption key that is used to encrypt this parameter.
     *
     * @default - default master key
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
}
/**
 * (experimental) Creates a new String SSM Parameter.
 *
 * @experimental
 * @resource AWS::SSM::Parameter
 */
export declare class StringParameter extends ParameterBase implements IStringParameter {
    /**
     * (experimental) Imports an external string parameter by name.
     *
     * @experimental
     */
    static fromStringParameterName(scope: Construct, id: string, stringParameterName: string): IStringParameter;
    /**
     * (experimental) Imports an external string parameter with name and optional version.
     *
     * @experimental
     */
    static fromStringParameterAttributes(scope: Construct, id: string, attrs: StringParameterAttributes): IStringParameter;
    /**
     * (experimental) Imports a secure string parameter from the SSM parameter store.
     *
     * @experimental
     */
    static fromSecureStringParameterAttributes(scope: Construct, id: string, attrs: SecureStringParameterAttributes): IStringParameter;
    /**
     * (experimental) Reads the value of an SSM parameter during synthesis through an environmental context provider.
     *
     * Requires that the stack this scope is defined in will have explicit
     * account/region information. Otherwise, it will fail during synthesis.
     *
     * @experimental
     */
    static valueFromLookup(scope: CompatConstruct, parameterName: string): string;
    /**
     * (experimental) Returns a token that will resolve (during deployment) to the string value of an SSM string parameter.
     *
     * @param scope Some scope within a stack.
     * @param parameterName The name of the SSM parameter.
     * @param version The parameter version (recommended in order to ensure that the value won't change during deployment).
     * @experimental
     */
    static valueForStringParameter(scope: Construct, parameterName: string, version?: number): string;
    /**
     * (experimental) Returns a token that will resolve (during deployment) to the string value of an SSM string parameter.
     *
     * @param scope Some scope within a stack.
     * @param parameterName The name of the SSM parameter.
     * @param type The type of the SSM parameter.
     * @param version The parameter version (recommended in order to ensure that the value won't change during deployment).
     * @experimental
     */
    static valueForTypedStringParameter(scope: Construct, parameterName: string, type?: ParameterType, version?: number): string;
    /**
     * (experimental) Returns a token that will resolve (during deployment).
     *
     * @param scope Some scope within a stack.
     * @param parameterName The name of the SSM parameter.
     * @param version The parameter version (required for secure strings).
     * @experimental
     */
    static valueForSecureStringParameter(scope: Construct, parameterName: string, version: number): string;
    /**
     * (experimental) The ARN of the SSM Parameter resource.
     *
     * @experimental
     */
    readonly parameterArn: string;
    /**
     * (experimental) The name of the SSM Parameter resource.
     *
     * @experimental
     */
    readonly parameterName: string;
    /**
     * (experimental) The type of the SSM Parameter resource.
     *
     * @experimental
     */
    readonly parameterType: string;
    /**
     * (experimental) The parameter value.
     *
     * Value must not nest another parameter. Do not use {{}} in the value.
     *
     * @experimental
     */
    readonly stringValue: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: StringParameterProps);
}
/**
 * (experimental) Creates a new StringList SSM Parameter.
 *
 * @experimental
 * @resource AWS::SSM::Parameter
 */
export declare class StringListParameter extends ParameterBase implements IStringListParameter {
    /**
     * (experimental) Imports an external parameter of type string list.
     *
     * Returns a token and should not be parsed.
     *
     * @experimental
     */
    static fromStringListParameterName(scope: Construct, id: string, stringListParameterName: string): IStringListParameter;
    /**
     * (experimental) The ARN of the SSM Parameter resource.
     *
     * @experimental
     */
    readonly parameterArn: string;
    /**
     * (experimental) The name of the SSM Parameter resource.
     *
     * @experimental
     */
    readonly parameterName: string;
    /**
     * (experimental) The type of the SSM Parameter resource.
     *
     * @experimental
     */
    readonly parameterType: string;
    /**
     * (experimental) The parameter value.
     *
     * Value must not nest another parameter. Do not use {{}} in the value. Values in the array
     * cannot contain commas (``,``).
     *
     * @experimental
     */
    readonly stringListValue: string[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: StringListParameterProps);
}
export {};
