"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateProps = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
function validateProps(props) {
    validateRange('delivery delay', props.deliveryDelay && props.deliveryDelay.toSeconds(), 0, 900, 'seconds');
    validateRange('maximum message size', props.maxMessageSizeBytes, 1024, 262144, 'bytes');
    validateRange('message retention period', props.retentionPeriod && props.retentionPeriod.toSeconds(), 60, 1209600, 'seconds');
    validateRange('receive wait time', props.receiveMessageWaitTime && props.receiveMessageWaitTime.toSeconds(), 0, 20, 'seconds');
    validateRange('visibility timeout', props.visibilityTimeout && props.visibilityTimeout.toSeconds(), 0, 43200, 'seconds');
    validateRange('dead letter target maximum receive count', props.deadLetterQueue && props.deadLetterQueue.maxReceiveCount, 1, +Infinity);
}
exports.validateProps = validateProps;
function validateRange(label, value, minValue, maxValue, unit) {
    if (value === undefined || core_1.Token.isUnresolved(value)) {
        return;
    }
    const unitSuffix = unit ? ` ${unit}` : '';
    if (value < minValue) {
        throw new Error(`${label} must be ${minValue}${unitSuffix} or more, but ${value} was provided`);
    }
    if (value > maxValue) {
        throw new Error(`${label} must be ${maxValue}${unitSuffix} of less, but ${value} was provided`);
    }
}
//# sourceMappingURL=data:application/json;base64,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