import * as cloudwatch from "../../aws-cloudwatch";
declare module "./queue-base" {
    /**
     * (experimental) Represents an SQS queue.
     *
     * @experimental
     */
    interface IQueue {
        /**
         * (experimental) Return the given named metric for this Queue.
         *
         * @experimental
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The approximate age of the oldest non-deleted message in the queue.
         *
         * Maximum over 5 minutes
         *
         * @experimental
         */
        metricApproximateAgeOfOldestMessage(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages in the queue that are delayed and not available for reading immediately.
         *
         * Maximum over 5 minutes
         *
         * @experimental
         */
        metricApproximateNumberOfMessagesDelayed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages that are in flight.
         *
         * Maximum over 5 minutes
         *
         * @experimental
         */
        metricApproximateNumberOfMessagesNotVisible(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages available for retrieval from the queue.
         *
         * Maximum over 5 minutes
         *
         * @experimental
         */
        metricApproximateNumberOfMessagesVisible(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of ReceiveMessage API calls that did not return a message.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfEmptyReceives(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages deleted from the queue.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfMessagesDeleted(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages returned by calls to the ReceiveMessage action.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfMessagesReceived(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages added to a queue.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfMessagesSent(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The size of messages added to a queue.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricSentMessageSize(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
    /**
     * (experimental) Reference to a new or existing Amazon SQS queue.
     *
     * @experimental
     */
    interface QueueBase {
        /**
         * (experimental) Return the given named metric for this Queue.
         *
         * @experimental
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The approximate age of the oldest non-deleted message in the queue.
         *
         * Maximum over 5 minutes
         *
         * @experimental
         */
        metricApproximateAgeOfOldestMessage(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages in the queue that are delayed and not available for reading immediately.
         *
         * Maximum over 5 minutes
         *
         * @experimental
         */
        metricApproximateNumberOfMessagesDelayed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages that are in flight.
         *
         * Maximum over 5 minutes
         *
         * @experimental
         */
        metricApproximateNumberOfMessagesNotVisible(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages available for retrieval from the queue.
         *
         * Maximum over 5 minutes
         *
         * @experimental
         */
        metricApproximateNumberOfMessagesVisible(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of ReceiveMessage API calls that did not return a message.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfEmptyReceives(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages deleted from the queue.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfMessagesDeleted(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages returned by calls to the ReceiveMessage action.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfMessagesReceived(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages added to a queue.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfMessagesSent(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The size of messages added to a queue.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricSentMessageSize(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
