import * as iam from "../../aws-iam";
import { IResource, Resource } from "../../core";
import { ITopicSubscription } from './subscriber';
/**
 * (experimental) Represents an SNS topic.
 *
 * @experimental
 */
export interface ITopic extends IResource {
    /**
     * (experimental) The ARN of the topic.
     *
     * @experimental
     * @attribute true
     */
    readonly topicArn: string;
    /**
     * (experimental) The name of the topic.
     *
     * @experimental
     * @attribute true
     */
    readonly topicName: string;
    /**
     * (experimental) Subscribe some endpoint to this topic.
     *
     * @experimental
     */
    addSubscription(subscription: ITopicSubscription): void;
    /**
     * (experimental) Adds a statement to the IAM resource policy associated with this topic.
     *
     * If this topic was created in this stack (`new Topic`), a topic policy
     * will be automatically created upon the first call to `addToPolicy`. If
     * the topic is imported (`Topic.import`), then this is a no-op.
     *
     * @experimental
     */
    addToResourcePolicy(statement: iam.PolicyStatement): iam.AddToResourcePolicyResult;
    /**
     * (experimental) Grant topic publishing permissions to the given identity.
     *
     * @experimental
     */
    grantPublish(identity: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) Either a new or imported Topic.
 *
 * @experimental
 */
export declare abstract class TopicBase extends Resource implements ITopic {
    /**
     * (experimental) The ARN of the topic.
     *
     * @experimental
     */
    abstract readonly topicArn: string;
    /**
     * (experimental) The name of the topic.
     *
     * @experimental
     */
    abstract readonly topicName: string;
    /**
     * (experimental) Controls automatic creation of policy objects.
     *
     * Set by subclasses.
     *
     * @experimental
     */
    protected abstract readonly autoCreatePolicy: boolean;
    private policy?;
    /**
     * (experimental) Subscribe some endpoint to this topic.
     *
     * @experimental
     */
    addSubscription(subscription: ITopicSubscription): void;
    /**
     * (experimental) Adds a statement to the IAM resource policy associated with this topic.
     *
     * If this topic was created in this stack (`new Topic`), a topic policy
     * will be automatically created upon the first call to `addToPolicy`. If
     * the topic is imported (`Topic.import`), then this is a no-op.
     *
     * @experimental
     */
    addToResourcePolicy(statement: iam.PolicyStatement): iam.AddToResourcePolicyResult;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    protected validate(): string[];
    /**
     * (experimental) Grant topic publishing permissions to the given identity.
     *
     * @experimental
     */
    grantPublish(grantee: iam.IGrantable): iam.Grant;
    private nextTokenId;
}
