"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionFilter = void 0;
/**
 * (experimental) A subscription filter for an attribute.
 *
 * @experimental
 */
class SubscriptionFilter {
    /**
     * @param conditions conditions that specify the message attributes that should be included, excluded, matched, etc.
     * @experimental
     */
    constructor(conditions = []) {
        this.conditions = conditions;
    }
    /**
     * (experimental) Returns a subscription filter for a string attribute.
     *
     * @experimental
     */
    static stringFilter(stringConditions) {
        const conditions = new Array();
        if (stringConditions.whitelist) {
            conditions.push(...stringConditions.whitelist);
        }
        if (stringConditions.blacklist) {
            conditions.push({ 'anything-but': stringConditions.blacklist });
        }
        if (stringConditions.matchPrefixes) {
            conditions.push(...stringConditions.matchPrefixes.map(p => ({ prefix: p })));
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * (experimental) Returns a subscription filter for a numeric attribute.
     *
     * @experimental
     */
    static numericFilter(numericConditions) {
        const conditions = new Array();
        if (numericConditions.whitelist) {
            conditions.push(...numericConditions.whitelist.map(v => ({ numeric: ['=', v] })));
        }
        if (numericConditions.greaterThan) {
            conditions.push({ numeric: ['>', numericConditions.greaterThan] });
        }
        if (numericConditions.greaterThanOrEqualTo) {
            conditions.push({ numeric: ['>=', numericConditions.greaterThanOrEqualTo] });
        }
        if (numericConditions.lessThan) {
            conditions.push({ numeric: ['<', numericConditions.lessThan] });
        }
        if (numericConditions.lessThanOrEqualTo) {
            conditions.push({ numeric: ['<=', numericConditions.lessThanOrEqualTo] });
        }
        if (numericConditions.between) {
            conditions.push({ numeric: ['>=', numericConditions.between.start, '<=', numericConditions.between.stop] });
        }
        if (numericConditions.betweenStrict) {
            conditions.push({ numeric: ['>', numericConditions.betweenStrict.start, '<', numericConditions.betweenStrict.stop] });
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * (experimental) Returns a subscription filter for attribute key matching.
     *
     * @experimental
     */
    static existsFilter() {
        return new SubscriptionFilter([{ exists: true }]);
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
//# sourceMappingURL=data:application/json;base64,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