/**
 * (experimental) Conditions that can be applied to string attributes.
 *
 * @experimental
 */
export interface StringConditions {
    /**
     * (experimental) Match one or more values.
     *
     * @default - None
     * @experimental
     */
    readonly whitelist?: string[];
    /**
     * (experimental) Match any value that doesn't include any of the specified values.
     *
     * @default - None
     * @experimental
     */
    readonly blacklist?: string[];
    /**
     * (experimental) Matches values that begins with the specified prefixes.
     *
     * @default - None
     * @experimental
     */
    readonly matchPrefixes?: string[];
}
/**
 * (experimental) Between condition for a numeric attribute.
 *
 * @experimental
 */
export interface BetweenCondition {
    /**
     * (experimental) The start value.
     *
     * @experimental
     */
    readonly start: number;
    /**
     * (experimental) The stop value.
     *
     * @experimental
     */
    readonly stop: number;
}
/**
 * (experimental) Conditions that can be applied to numeric attributes.
 *
 * @experimental
 */
export interface NumericConditions {
    /**
     * (experimental) Match one or more values.
     *
     * @default - None
     * @experimental
     */
    readonly whitelist?: number[];
    /**
     * (experimental) Match values that are greater than the specified value.
     *
     * @default - None
     * @experimental
     */
    readonly greaterThan?: number;
    /**
     * (experimental) Match values that are greater than or equal to the specified value.
     *
     * @default - None
     * @experimental
     */
    readonly greaterThanOrEqualTo?: number;
    /**
     * (experimental) Match values that are less than the specified value.
     *
     * @default - None
     * @experimental
     */
    readonly lessThan?: number;
    /**
     * (experimental) Match values that are less than or equal to the specified value.
     *
     * @default - None
     * @experimental
     */
    readonly lessThanOrEqualTo?: number;
    /**
     * (experimental) Match values that are between the specified values.
     *
     * @default - None
     * @experimental
     */
    readonly between?: BetweenCondition;
    /**
     * (experimental) Match values that are strictly between the specified values.
     *
     * @default - None
     * @experimental
     */
    readonly betweenStrict?: BetweenCondition;
}
/**
 * (experimental) A subscription filter for an attribute.
 *
 * @experimental
 */
export declare class SubscriptionFilter {
    readonly conditions: any[];
    /**
     * (experimental) Returns a subscription filter for a string attribute.
     *
     * @experimental
     */
    static stringFilter(stringConditions: StringConditions): SubscriptionFilter;
    /**
     * (experimental) Returns a subscription filter for a numeric attribute.
     *
     * @experimental
     */
    static numericFilter(numericConditions: NumericConditions): SubscriptionFilter;
    /**
     * (experimental) Returns a subscription filter for attribute key matching.
     *
     * @experimental
     */
    static existsFilter(): SubscriptionFilter;
    /**
     * @param conditions conditions that specify the message attributes that should be included, excluded, matched, etc.
     * @experimental
     */
    constructor(conditions?: any[]);
}
