import * as cloudwatch from "../../aws-cloudwatch";
declare module "./topic-base" {
    /**
     * (experimental) Represents an SNS topic.
     *
     * @experimental
     */
    interface ITopic {
        /**
         * (experimental) Return the given named metric for this Topic.
         *
         * @experimental
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) Metric for the size of messages published through this topic.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricPublishSize(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages published to your Amazon SNS topics.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfMessagesPublished(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages successfully delivered from your Amazon SNS topics to subscribing endpoints.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfNotificationsDelivered(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages that Amazon SNS failed to deliver.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfNotificationsFailed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages that were rejected by subscription filter policies.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfNotificationsFilteredOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages that were rejected by subscription filter policies because the messages have no attributes.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfNotificationsFilteredOutNoMessageAttributes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages that were rejected by subscription filter policies because the messages' attributes are invalid.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfNotificationsFilteredOutInvalidAttributes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The charges you have accrued since the start of the current calendar month for sending SMS messages.
         *
         * Maximum over 5 minutes
         *
         * @experimental
         */
        metricSMSMonthToDateSpentUSD(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The rate of successful SMS message deliveries.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricSMSSuccessRate(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
    /**
     * (experimental) Either a new or imported Topic.
     *
     * @experimental
     */
    interface TopicBase {
        /**
         * (experimental) Return the given named metric for this Topic.
         *
         * @experimental
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) Metric for the size of messages published through this topic.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricPublishSize(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages published to your Amazon SNS topics.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfMessagesPublished(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages successfully delivered from your Amazon SNS topics to subscribing endpoints.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfNotificationsDelivered(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages that Amazon SNS failed to deliver.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfNotificationsFailed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages that were rejected by subscription filter policies.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfNotificationsFilteredOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages that were rejected by subscription filter policies because the messages have no attributes.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfNotificationsFilteredOutNoMessageAttributes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The number of messages that were rejected by subscription filter policies because the messages' attributes are invalid.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricNumberOfNotificationsFilteredOutInvalidAttributes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The charges you have accrued since the start of the current calendar month for sending SMS messages.
         *
         * Maximum over 5 minutes
         *
         * @experimental
         */
        metricSMSMonthToDateSpentUSD(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) The rate of successful SMS message deliveries.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricSMSSuccessRate(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
