"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmsSubscription = void 0;
const sns = require("../../aws-sns"); // Automatically re-written from '@aws-cdk/aws-sns'
/**
 * (experimental) Use an sms address as a subscription target.
 *
 * @experimental
 */
class SmsSubscription {
    /**
     * @experimental
     */
    constructor(phoneNumber, props = {}) {
        this.phoneNumber = phoneNumber;
        this.props = props;
    }
    /**
     * (experimental) Returns a configuration used to subscribe to an SNS topic.
     *
     * @experimental
     */
    bind(_topic) {
        return {
            subscriberId: this.phoneNumber,
            endpoint: this.phoneNumber,
            protocol: sns.SubscriptionProtocol.SMS,
            filterPolicy: this.props.filterPolicy,
        };
    }
}
exports.SmsSubscription = SmsSubscription;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic21zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic21zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHFDQUFxQyxDQUFDLG1EQUFtRDs7Ozs7O0FBVXpGLE1BQWEsZUFBZTs7OztJQUN4QixZQUE2QixXQUFtQixFQUFtQixRQUE4QixFQUFFO1FBQXRFLGdCQUFXLEdBQVgsV0FBVyxDQUFRO1FBQW1CLFVBQUssR0FBTCxLQUFLLENBQTJCO0lBQ25HLENBQUM7Ozs7OztJQUNNLElBQUksQ0FBQyxNQUFrQjtRQUMxQixPQUFPO1lBQ0gsWUFBWSxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzlCLFFBQVEsRUFBRSxJQUFJLENBQUMsV0FBVztZQUMxQixRQUFRLEVBQUUsR0FBRyxDQUFDLG9CQUFvQixDQUFDLEdBQUc7WUFDdEMsWUFBWSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWTtTQUN4QyxDQUFDO0lBQ04sQ0FBQztDQUNKO0FBWEQsMENBV0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBzbnMgZnJvbSBcIi4uLy4uL2F3cy1zbnNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnXG5pbXBvcnQgeyBTdWJzY3JpcHRpb25Qcm9wcyB9IGZyb20gJy4vc3Vic2NyaXB0aW9uJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFNtc1N1YnNjcmlwdGlvblByb3BzIGV4dGVuZHMgU3Vic2NyaXB0aW9uUHJvcHMge1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgU21zU3Vic2NyaXB0aW9uIGltcGxlbWVudHMgc25zLklUb3BpY1N1YnNjcmlwdGlvbiB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwaG9uZU51bWJlcjogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBTbXNTdWJzY3JpcHRpb25Qcm9wcyA9IHt9KSB7XG4gICAgfVxuICAgIHB1YmxpYyBiaW5kKF90b3BpYzogc25zLklUb3BpYyk6IHNucy5Ub3BpY1N1YnNjcmlwdGlvbkNvbmZpZyB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBzdWJzY3JpYmVySWQ6IHRoaXMucGhvbmVOdW1iZXIsXG4gICAgICAgICAgICBlbmRwb2ludDogdGhpcy5waG9uZU51bWJlcixcbiAgICAgICAgICAgIHByb3RvY29sOiBzbnMuU3Vic2NyaXB0aW9uUHJvdG9jb2wuU01TLFxuICAgICAgICAgICAgZmlsdGVyUG9saWN5OiB0aGlzLnByb3BzLmZpbHRlclBvbGljeSxcbiAgICAgICAgfTtcbiAgICB9XG59XG4iXX0=