"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailSubscription = void 0;
const sns = require("../../aws-sns"); // Automatically re-written from '@aws-cdk/aws-sns'
/**
 * (experimental) Use an email address as a subscription target.
 *
 * Email subscriptions require confirmation.
 *
 * @experimental
 */
class EmailSubscription {
    /**
     * @experimental
     */
    constructor(emailAddress, props = {}) {
        this.emailAddress = emailAddress;
        this.props = props;
    }
    /**
     * (experimental) Returns a configuration for an email address to subscribe to an SNS topic.
     *
     * @experimental
     */
    bind(_topic) {
        return {
            subscriberId: this.emailAddress,
            endpoint: this.emailAddress,
            protocol: this.props.json ? sns.SubscriptionProtocol.EMAIL_JSON : sns.SubscriptionProtocol.EMAIL,
            filterPolicy: this.props.filterPolicy,
            deadLetterQueue: this.props.deadLetterQueue,
        };
    }
}
exports.EmailSubscription = EmailSubscription;
//# sourceMappingURL=data:application/json;base64,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