import * as ses from "../../aws-ses";
import * as sns from "../../aws-sns";
/**
 * (experimental) The type of email encoding to use for a SNS action.
 *
 * @experimental
 */
export declare enum EmailEncoding {
    /**
     * (experimental) Base 64.
     *
     * @experimental
     */
    BASE64 = "Base64",
    /**
     * (experimental) UTF-8.
     *
     * @experimental
     */
    UTF8 = "UTF-8"
}
/**
 * (experimental) Construction properties for a SNS action.
 *
 * @experimental
 */
export interface SnsProps {
    /**
     * (experimental) The encoding to use for the email within the Amazon SNS notification.
     *
     * @default UTF-8
     * @experimental
     */
    readonly encoding?: EmailEncoding;
    /**
     * (experimental) The SNS topic to notify.
     *
     * @experimental
     */
    readonly topic: sns.ITopic;
}
/**
 * (experimental) Publishes the email content within a notification to Amazon SNS.
 *
 * @experimental
 */
export declare class Sns implements ses.IReceiptRuleAction {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: SnsProps);
    /**
     * (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(_rule: ses.IReceiptRule): ses.ReceiptRuleActionConfig;
}
