import * as lambda from "../../aws-lambda";
import * as ses from "../../aws-ses";
import * as sns from "../../aws-sns";
/**
 * (experimental) The type of invocation to use for a Lambda Action.
 *
 * @experimental
 */
export declare enum LambdaInvocationType {
    /**
     * (experimental) The function will be invoked asynchronously.
     *
     * @experimental
     */
    EVENT = "Event",
    /**
     * (experimental) The function will be invoked sychronously.
     *
     * Use RequestResponse only when
     * you want to make a mail flow decision, such as whether to stop the receipt
     * rule or the receipt rule set.
     *
     * @experimental
     */
    REQUEST_RESPONSE = "RequestResponse"
}
/**
 * (experimental) Construction properties for a Lambda action.
 *
 * @experimental
 */
export interface LambdaProps {
    /**
     * (experimental) The Lambda function to invoke.
     *
     * @experimental
     */
    readonly function: lambda.IFunction;
    /**
     * (experimental) The invocation type of the Lambda function.
     *
     * @default Event
     * @experimental
     */
    readonly invocationType?: LambdaInvocationType;
    /**
     * (experimental) The SNS topic to notify when the Lambda action is taken.
     *
     * @default no notification
     * @experimental
     */
    readonly topic?: sns.ITopic;
}
/**
 * (experimental) Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
 *
 * @experimental
 */
export declare class Lambda implements ses.IReceiptRuleAction {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: LambdaProps);
    /**
     * (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(rule: ses.IReceiptRule): ses.ReceiptRuleActionConfig;
}
