"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bounce = exports.BounceTemplate = void 0;
/**
 * (experimental) A bounce template.
 *
 * @experimental
 */
class BounceTemplate {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
}
exports.BounceTemplate = BounceTemplate;
/**
 * @experimental
 */
BounceTemplate.MAILBOX_DOES_NOT_EXIST = new BounceTemplate({
    message: 'Mailbox does not exist',
    smtpReplyCode: '550',
    statusCode: '5.1.1',
});
/**
 * @experimental
 */
BounceTemplate.MESSAGE_TOO_LARGE = new BounceTemplate({
    message: 'Message too large',
    smtpReplyCode: '552',
    statusCode: '5.3.4',
});
/**
 * @experimental
 */
BounceTemplate.MAILBOX_FULL = new BounceTemplate({
    message: 'Mailbox full',
    smtpReplyCode: '552',
    statusCode: '5.2.2',
});
/**
 * @experimental
 */
BounceTemplate.MESSAGE_CONTENT_REJECTED = new BounceTemplate({
    message: 'Message content rejected',
    smtpReplyCode: '500',
    statusCode: '5.6.1',
});
/**
 * @experimental
 */
BounceTemplate.TEMPORARY_FAILURE = new BounceTemplate({
    message: 'Temporary failure',
    smtpReplyCode: '450',
    statusCode: '4.0.0',
});
/**
 * (experimental) Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon SNS.
 *
 * @experimental
 */
class Bounce {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(_rule) {
        return {
            bounceAction: {
                sender: this.props.sender,
                smtpReplyCode: this.props.template.props.smtpReplyCode,
                message: this.props.template.props.message,
                topicArn: this.props.topic ? this.props.topic.topicArn : undefined,
                statusCode: this.props.template.props.statusCode,
            },
        };
    }
}
exports.Bounce = Bounce;
//# sourceMappingURL=data:application/json;base64,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