import * as elbv2 from "../../aws-elasticloadbalancingv2";
import { Duration, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { CnameInstanceBaseProps } from './cname-instance';
import { IInstance } from './instance';
import { IpInstanceBaseProps } from './ip-instance';
import { INamespace } from './namespace';
import { NonIpInstanceBaseProps } from './non-ip-instance';
/**
 * @experimental
 */
export interface IService extends IResource {
    /**
     * (experimental) A name for the Cloudmap Service.
     *
     * @experimental
     * @attribute true
     */
    readonly serviceName: string;
    /**
     * (experimental) The namespace for the Cloudmap Service.
     *
     * @experimental
     */
    readonly namespace: INamespace;
    /**
     * (experimental) The ID of the namespace that you want to use for DNS configuration.
     *
     * @experimental
     * @attribute true
     */
    readonly serviceId: string;
    /**
     * (experimental) The Arn of the namespace that you want to use for DNS configuration.
     *
     * @experimental
     * @attribute true
     */
    readonly serviceArn: string;
    /**
     * (experimental) The DnsRecordType used by the service.
     *
     * @experimental
     */
    readonly dnsRecordType: DnsRecordType;
    /**
     * (experimental) The Routing Policy used by the service.
     *
     * @experimental
     */
    readonly routingPolicy: RoutingPolicy;
}
/**
 * (experimental) Basic props needed to create a service in a given namespace.
 *
 * Used by HttpNamespace.createService
 *
 * @experimental
 */
export interface BaseServiceProps {
    /**
     * (experimental) A name for the Service.
     *
     * @default CloudFormation-generated name
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) A description of the service.
     *
     * @default none
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Settings for an optional health check.
     *
     * If you specify health check settings, AWS Cloud Map associates the health
     * check with the records that you specify in DnsConfig. Only one of healthCheckConfig or healthCheckCustomConfig can
     * be specified. Not valid for PrivateDnsNamespaces. If you use healthCheck, you can only register IP instances to
     * this service.
     *
     * @default none
     * @experimental
     */
    readonly healthCheck?: HealthCheckConfig;
    /**
     * (experimental) Structure containing failure threshold for a custom health checker.
     *
     * Only one of healthCheckConfig or healthCheckCustomConfig can be specified.
     * See: https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html
     *
     * @default none
     * @experimental
     */
    readonly customHealthCheck?: HealthCheckCustomConfig;
}
/**
 * (experimental) Service props needed to create a service in a given namespace.
 *
 * Used by createService() for PrivateDnsNamespace and
 * PublicDnsNamespace
 *
 * @experimental
 */
export interface DnsServiceProps extends BaseServiceProps {
    /**
     * (experimental) The DNS type of the record that you want AWS Cloud Map to create.
     *
     * Supported record types
     * include A, AAAA, A and AAAA (A_AAAA), CNAME, and SRV.
     *
     * @default A
     * @experimental
     */
    readonly dnsRecordType?: DnsRecordType;
    /**
     * (experimental) The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.
     *
     * @default Duration.minutes(1)
     * @experimental
     */
    readonly dnsTtl?: Duration;
    /**
     * (experimental) The routing policy that you want to apply to all DNS records that AWS Cloud Map creates when you register an instance and specify this service.
     *
     * @default WEIGHTED for CNAME records and when loadBalancer is true, MULTIVALUE otherwise
     * @experimental
     */
    readonly routingPolicy?: RoutingPolicy;
    /**
     * (experimental) Whether or not this service will have an Elastic LoadBalancer registered to it as an AliasTargetInstance.
     *
     * Setting this to `true` correctly configures the `routingPolicy`
     * and performs some additional validation.
     *
     * @default false
     * @experimental
     */
    readonly loadBalancer?: boolean;
}
/**
 * @experimental
 */
export interface ServiceProps extends DnsServiceProps {
    /**
     * (experimental) The namespace that you want to use for DNS configuration.
     *
     * @experimental
     */
    readonly namespace: INamespace;
}
declare abstract class ServiceBase extends Resource implements IService {
    abstract namespace: INamespace;
    abstract serviceId: string;
    abstract serviceArn: string;
    abstract dnsRecordType: DnsRecordType;
    abstract routingPolicy: RoutingPolicy;
    abstract readonly serviceName: string;
}
/**
 * @experimental
 */
export interface ServiceAttributes {
    /**
     * @experimental
     */
    readonly namespace: INamespace;
    /**
     * @experimental
     */
    readonly serviceName: string;
    /**
     * @experimental
     */
    readonly serviceId: string;
    /**
     * @experimental
     */
    readonly serviceArn: string;
    /**
     * @experimental
     */
    readonly dnsRecordType: DnsRecordType;
    /**
     * @experimental
     */
    readonly routingPolicy: RoutingPolicy;
}
/**
 * (experimental) Define a CloudMap Service.
 *
 * @experimental
 */
export declare class Service extends ServiceBase {
    /**
     * @experimental
     */
    static fromServiceAttributes(scope: Construct, id: string, attrs: ServiceAttributes): IService;
    /**
     * (experimental) A name for the Cloudmap Service.
     *
     * @experimental
     */
    readonly serviceName: string;
    /**
     * (experimental) The namespace for the Cloudmap Service.
     *
     * @experimental
     */
    readonly namespace: INamespace;
    /**
     * (experimental) The ID of the namespace that you want to use for DNS configuration.
     *
     * @experimental
     */
    readonly serviceId: string;
    /**
     * (experimental) The Arn of the namespace that you want to use for DNS configuration.
     *
     * @experimental
     */
    readonly serviceArn: string;
    /**
     * (experimental) The DnsRecordType used by the service.
     *
     * @experimental
     */
    readonly dnsRecordType: DnsRecordType;
    /**
     * (experimental) The Routing Policy used by the service.
     *
     * @experimental
     */
    readonly routingPolicy: RoutingPolicy;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ServiceProps);
    /**
     * (experimental) Registers an ELB as a new instance with unique name instanceId in this service.
     *
     * @experimental
     */
    registerLoadBalancer(id: string, loadBalancer: elbv2.ILoadBalancerV2, customAttributes?: {
        [key: string]: string;
    }): IInstance;
    /**
     * (experimental) Registers a resource that is accessible using values other than an IP address or a domain name (CNAME).
     *
     * @experimental
     */
    registerNonIpInstance(id: string, props: NonIpInstanceBaseProps): IInstance;
    /**
     * (experimental) Registers a resource that is accessible using an IP address.
     *
     * @experimental
     */
    registerIpInstance(id: string, props: IpInstanceBaseProps): IInstance;
    /**
     * (experimental) Registers a resource that is accessible using a CNAME.
     *
     * @experimental
     */
    registerCnameInstance(id: string, props: CnameInstanceBaseProps): IInstance;
}
/**
 * (experimental) Settings for an optional Amazon Route 53 health check.
 *
 * If you specify settings for a health check, AWS Cloud Map
 * associates the health check with all the records that you specify in DnsConfig. Only valid with a PublicDnsNamespace.
 *
 * @experimental
 */
export interface HealthCheckConfig {
    /**
     * (experimental) The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy.
     *
     * Cannot be modified once created. Supported values are HTTP, HTTPS, and TCP.
     *
     * @default HTTP
     * @experimental
     */
    readonly type?: HealthCheckType;
    /**
     * (experimental) The path that you want Route 53 to request when performing health checks.
     *
     * Do not use when health check type is TCP.
     *
     * @default '/'
     * @experimental
     */
    readonly resourcePath?: string;
    /**
     * (experimental) The number of consecutive health checks that an endpoint must pass or fail for Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa.
     *
     * @default 1
     * @experimental
     */
    readonly failureThreshold?: number;
}
/**
 * (experimental) Specifies information about an optional custom health check.
 *
 * @experimental
 */
export interface HealthCheckCustomConfig {
    /**
     * (experimental) The number of 30-second intervals that you want Cloud Map to wait after receiving an UpdateInstanceCustomHealthStatus request before it changes the health status of a service instance.
     *
     * @default 1
     * @experimental
     */
    readonly failureThreshold?: number;
}
/**
 * @experimental
 */
export declare enum DnsRecordType {
    /**
     * (experimental) An A record.
     *
     * @experimental
     */
    A = "A",
    /**
     * (experimental) An AAAA record.
     *
     * @experimental
     */
    AAAA = "AAAA",
    /**
     * (experimental) Both an A and AAAA record.
     *
     * @experimental
     */
    A_AAAA = "A, AAAA",
    /**
     * (experimental) A Srv record.
     *
     * @experimental
     */
    SRV = "SRV",
    /**
     * (experimental) A CNAME record.
     *
     * @experimental
     */
    CNAME = "CNAME"
}
/**
 * @experimental
 */
export declare enum RoutingPolicy {
    /**
     * (experimental) Route 53 returns the applicable value from one randomly selected instance from among the instances that you registered using the same service.
     *
     * @experimental
     */
    WEIGHTED = "WEIGHTED",
    /**
     * (experimental) If you define a health check for the service and the health check is healthy, Route 53 returns the applicable value for up to eight instances.
     *
     * @experimental
     */
    MULTIVALUE = "MULTIVALUE"
}
/**
 * @experimental
 */
export declare enum HealthCheckType {
    /**
     * (experimental) Route 53 tries to establish a TCP connection.
     *
     * If successful, Route 53 submits an HTTP request and waits for an HTTP
     * status code of 200 or greater and less than 400.
     *
     * @experimental
     */
    HTTP = "HTTP",
    /**
     * (experimental) Route 53 tries to establish a TCP connection.
     *
     * If successful, Route 53 submits an HTTPS request and waits for an
     * HTTP status code of 200 or greater and less than 400.  If you specify HTTPS for the value of Type, the endpoint
     * must support TLS v1.0 or later.
     *
     * @experimental
     */
    HTTPS = "HTTPS",
    /**
     * (experimental) Route 53 tries to establish a TCP connection.
     *
     * If you specify TCP for Type, don't specify a value for ResourcePath.
     *
     * @experimental
     */
    TCP = "TCP"
}
export {};
