"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HostedRotationType = exports.HostedRotation = exports.RotationSchedule = void 0;
const ec2 = require("../../aws-ec2"); // Automatically re-written from '@aws-cdk/aws-ec2'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const secretsmanager_generated_1 = require("./secretsmanager.generated");
/**
 * (experimental) A rotation schedule.
 *
 * @experimental
 */
class RotationSchedule extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        if ((!props.rotationLambda && !props.hostedRotation) || (props.rotationLambda && props.hostedRotation)) {
            throw new Error('One of `rotationLambda` or `hostedRotation` must be specified.');
        }
        new secretsmanager_generated_1.CfnRotationSchedule(this, 'Resource', {
            secretId: props.secret.secretArn,
            rotationLambdaArn: (_a = props.rotationLambda) === null || _a === void 0 ? void 0 : _a.functionArn,
            hostedRotationLambda: (_b = props.hostedRotation) === null || _b === void 0 ? void 0 : _b.bind(props.secret, this),
            rotationRules: {
                automaticallyAfterDays: props.automaticallyAfter && props.automaticallyAfter.toDays() || 30,
            },
        });
        // Prevent secrets deletions when rotation is in place
        props.secret.denyAccountRootDelete();
    }
}
exports.RotationSchedule = RotationSchedule;
/**
 * (experimental) A hosted rotation.
 *
 * @experimental
 */
class HostedRotation {
    constructor(type, props, masterSecret) {
        this.type = type;
        this.props = props;
        this.masterSecret = masterSecret;
        if (type.isMultiUser && !masterSecret) {
            throw new Error('The `masterSecret` must be specified when using the multi user scheme.');
        }
    }
    /**
     * (experimental) MySQL Single User.
     *
     * @experimental
     */
    static mysqlSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.MYSQL_SINGLE_USER, options);
    }
    /**
     * (experimental) MySQL Multi User.
     *
     * @experimental
     */
    static mysqlMultiUser(options) {
        return new HostedRotation(HostedRotationType.MYSQL_MULTI_USER, options, options.masterSecret);
    }
    /**
     * (experimental) PostgreSQL Single User.
     *
     * @experimental
     */
    static postgreSqlSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.POSTGRESQL_SINGLE_USER, options);
    }
    /**
     * (experimental) PostgreSQL Multi User.
     *
     * @experimental
     */
    static postgreSqlMultiUser(options) {
        return new HostedRotation(HostedRotationType.POSTGRESQL_MULTI_USER, options, options.masterSecret);
    }
    /**
     * (experimental) Oracle Single User.
     *
     * @experimental
     */
    static oracleSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.ORACLE_SINGLE_USER, options);
    }
    /**
     * (experimental) Oracle Multi User.
     *
     * @experimental
     */
    static oracleMultiUser(options) {
        return new HostedRotation(HostedRotationType.ORACLE_MULTI_USER, options, options.masterSecret);
    }
    /**
     * (experimental) MariaDB Single User.
     *
     * @experimental
     */
    static mariaDbSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.MARIADB_SINGLE_USER, options);
    }
    /**
     * (experimental) MariaDB Multi User.
     *
     * @experimental
     */
    static mariaDbMultiUser(options) {
        return new HostedRotation(HostedRotationType.MARIADB_MULTI_USER, options, options.masterSecret);
    }
    /**
     * (experimental) SQL Server Single User.
     *
     * @experimental
     */
    static sqlServerSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.SQLSERVER_SINGLE_USER, options);
    }
    /**
     * (experimental) SQL Server Multi User.
     *
     * @experimental
     */
    static sqlServerMultiUser(options) {
        return new HostedRotation(HostedRotationType.SQLSERVER_MULTI_USER, options, options.masterSecret);
    }
    /**
     * (experimental) Redshift Single User.
     *
     * @experimental
     */
    static redshiftSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.REDSHIFT_SINGLE_USER, options);
    }
    /**
     * (experimental) Redshift Multi User.
     *
     * @experimental
     */
    static redshiftMultiUser(options) {
        return new HostedRotation(HostedRotationType.REDSHIFT_MULTI_USER, options, options.masterSecret);
    }
    /**
     * (experimental) MongoDB Single User.
     *
     * @experimental
     */
    static mongoDbSingleUser(options = {}) {
        return new HostedRotation(HostedRotationType.MONGODB_SINGLE_USER, options);
    }
    /**
     * (experimental) MongoDB Multi User.
     *
     * @experimental
     */
    static mongoDbMultiUser(options) {
        return new HostedRotation(HostedRotationType.MONGODB_MULTI_USER, options, options.masterSecret);
    }
    /**
     * (experimental) Binds this hosted rotation to a secret.
     *
     * @experimental
     */
    bind(secret, scope) {
        var _a, _b, _c, _d, _e, _f, _g;
        // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-hostedrotationlambda.html
        core_1.Stack.of(scope).addTransform('AWS::SecretsManager-2020-07-23');
        if (!this.props.vpc && this.props.securityGroups) {
            throw new Error('`vpc` must be specified when specifying `securityGroups`.');
        }
        if (this.props.vpc) {
            this._connections = new ec2.Connections({
                securityGroups: this.props.securityGroups || [new ec2.SecurityGroup(scope, 'SecurityGroup', {
                        vpc: this.props.vpc,
                    })],
            });
        }
        // Prevent master secret deletion when rotation is in place
        if (this.masterSecret) {
            this.masterSecret.denyAccountRootDelete();
        }
        return {
            rotationType: this.type.name,
            kmsKeyArn: (_a = secret.encryptionKey) === null || _a === void 0 ? void 0 : _a.keyArn,
            masterSecretArn: (_b = this.masterSecret) === null || _b === void 0 ? void 0 : _b.secretArn,
            masterSecretKmsKeyArn: (_d = (_c = this.masterSecret) === null || _c === void 0 ? void 0 : _c.encryptionKey) === null || _d === void 0 ? void 0 : _d.keyArn,
            rotationLambdaName: this.props.functionName,
            vpcSecurityGroupIds: (_f = (_e = this._connections) === null || _e === void 0 ? void 0 : _e.securityGroups) === null || _f === void 0 ? void 0 : _f.map(s => s.securityGroupId).join(','),
            vpcSubnetIds: (_g = this.props.vpc) === null || _g === void 0 ? void 0 : _g.selectSubnets(this.props.vpcSubnets).subnetIds.join(','),
        };
    }
    /**
     * (experimental) Security group connections for this hosted rotation.
     *
     * @experimental
     */
    get connections() {
        if (!this.props.vpc) {
            throw new Error('Cannot use connections for a hosted rotation that is not deployed in a VPC');
        }
        // If we are in a vpc and bind() has been called _connections should be defined
        if (!this._connections) {
            throw new Error('Cannot use connections for a hosted rotation that has not been bound to a secret');
        }
        return this._connections;
    }
}
exports.HostedRotation = HostedRotation;
/**
 * (experimental) Hosted rotation type.
 *
 * @experimental
 */
class HostedRotationType {
    /**
     * @param name The type of rotation
     * @param isMultiUser Whether the rotation uses the mutli user scheme
     */
    constructor(name, isMultiUser) {
        this.name = name;
        this.isMultiUser = isMultiUser;
    }
}
exports.HostedRotationType = HostedRotationType;
/**
 * (experimental) MySQL Single User.
 *
 * @experimental
 */
HostedRotationType.MYSQL_SINGLE_USER = new HostedRotationType('MySQLSingleUser');
/**
 * (experimental) MySQL Multi User.
 *
 * @experimental
 */
HostedRotationType.MYSQL_MULTI_USER = new HostedRotationType('MySQLMultiUser', true);
/**
 * (experimental) PostgreSQL Single User.
 *
 * @experimental
 */
HostedRotationType.POSTGRESQL_SINGLE_USER = new HostedRotationType('PostgreSQLSingleUser');
/**
 * (experimental) PostgreSQL Multi User.
 *
 * @experimental
 */
HostedRotationType.POSTGRESQL_MULTI_USER = new HostedRotationType('PostgreSQLMultiUser', true);
/**
 * (experimental) Oracle Single User.
 *
 * @experimental
 */
HostedRotationType.ORACLE_SINGLE_USER = new HostedRotationType('OracleSingleUser');
/**
 * (experimental) Oracle Multi User.
 *
 * @experimental
 */
HostedRotationType.ORACLE_MULTI_USER = new HostedRotationType('OracleMultiUser', true);
/**
 * (experimental) MariaDB Single User.
 *
 * @experimental
 */
HostedRotationType.MARIADB_SINGLE_USER = new HostedRotationType('MariaDBSingleUser');
/**
 * (experimental) MariaDB Multi User.
 *
 * @experimental
 */
HostedRotationType.MARIADB_MULTI_USER = new HostedRotationType('MariaDBMultiUser', true);
/**
 * (experimental) SQL Server Single User.
 *
 * @experimental
 */
HostedRotationType.SQLSERVER_SINGLE_USER = new HostedRotationType('SQLServerSingleUser');
/**
 * (experimental) SQL Server Multi User.
 *
 * @experimental
 */
HostedRotationType.SQLSERVER_MULTI_USER = new HostedRotationType('SQLServerMultiUser', true);
/**
 * (experimental) Redshift Single User.
 *
 * @experimental
 */
HostedRotationType.REDSHIFT_SINGLE_USER = new HostedRotationType('RedshiftSingleUser');
/**
 * (experimental) Redshift Multi User.
 *
 * @experimental
 */
HostedRotationType.REDSHIFT_MULTI_USER = new HostedRotationType('RedshiftMultiUser', true);
/**
 * (experimental) MongoDB Single User.
 *
 * @experimental
 */
HostedRotationType.MONGODB_SINGLE_USER = new HostedRotationType('MongoDBSingleUser');
/**
 * (experimental) MongoDB Multi User.
 *
 * @experimental
 */
HostedRotationType.MONGODB_MULTI_USER = new HostedRotationType('MongoDBMultiUser', true);
//# sourceMappingURL=data:application/json;base64,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