import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::SageMaker::CodeRepository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 * @external
 */
export interface CfnCodeRepositoryProps {
    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     * @external
     */
    readonly gitConfig: CfnCodeRepository.GitConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::CodeRepository.CodeRepositoryName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
     * @external
     */
    readonly codeRepositoryName?: string;
}
/**
 * A CloudFormation `AWS::SageMaker::CodeRepository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 * @external
 * @cloudformationResource AWS::SageMaker::CodeRepository
 */
export declare class CfnCodeRepository extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::CodeRepository";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCodeRepository;
    /**
     * @external
     * @cloudformationAttribute CodeRepositoryName
     */
    readonly attrCodeRepositoryName: string;
    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     * @external
     */
    gitConfig: CfnCodeRepository.GitConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::CodeRepository.CodeRepositoryName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
     * @external
     */
    codeRepositoryName: string | undefined;
    /**
     * Create a new `AWS::SageMaker::CodeRepository`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCodeRepositoryProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::CodeRepository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 * @external
 * @cloudformationResource AWS::SageMaker::CodeRepository
 */
export declare namespace CfnCodeRepository {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html
     * @external
     */
    interface GitConfigProperty {
        /**
         * `CfnCodeRepository.GitConfigProperty.Branch`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-branch
         * @external
         */
        readonly branch?: string;
        /**
         * `CfnCodeRepository.GitConfigProperty.RepositoryUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-repositoryurl
         * @external
         */
        readonly repositoryUrl: string;
        /**
         * `CfnCodeRepository.GitConfigProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-secretarn
         * @external
         */
        readonly secretArn?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 * @external
 */
export interface CfnEndpointProps {
    /**
     * `AWS::SageMaker::Endpoint.EndpointConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
     * @external
     */
    readonly endpointConfigName: string;
    /**
     * `AWS::SageMaker::Endpoint.EndpointName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
     * @external
     */
    readonly endpointName?: string;
    /**
     * `AWS::SageMaker::Endpoint.ExcludeRetainedVariantProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
     * @external
     */
    readonly excludeRetainedVariantProperties?: Array<CfnEndpoint.VariantPropertyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Endpoint.RetainAllVariantProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
     * @external
     */
    readonly retainAllVariantProperties?: boolean | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Endpoint.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 */
export declare class CfnEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Endpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEndpoint;
    /**
     * @external
     * @cloudformationAttribute EndpointName
     */
    readonly attrEndpointName: string;
    /**
     * `AWS::SageMaker::Endpoint.EndpointConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
     * @external
     */
    endpointConfigName: string;
    /**
     * `AWS::SageMaker::Endpoint.EndpointName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
     * @external
     */
    endpointName: string | undefined;
    /**
     * `AWS::SageMaker::Endpoint.ExcludeRetainedVariantProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
     * @external
     */
    excludeRetainedVariantProperties: Array<CfnEndpoint.VariantPropertyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Endpoint.RetainAllVariantProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
     * @external
     */
    retainAllVariantProperties: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Endpoint.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::Endpoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEndpointProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html
     * @external
     */
    interface VariantPropertyProperty {
        /**
         * `CfnEndpoint.VariantPropertyProperty.VariantPropertyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html#cfn-sagemaker-endpoint-variantproperty-variantpropertytype
         * @external
         */
        readonly variantPropertyType?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::EndpointConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 * @external
 */
export interface CfnEndpointConfigProps {
    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     * @external
     */
    readonly productionVariants: Array<CfnEndpointConfig.ProductionVariantProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
     * @external
     */
    readonly dataCaptureConfig?: CfnEndpointConfig.DataCaptureConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     * @external
     */
    readonly endpointConfigName?: string;
    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::SageMaker::EndpointConfig.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 */
export declare class CfnEndpointConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::EndpointConfig";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEndpointConfig;
    /**
     * @external
     * @cloudformationAttribute EndpointConfigName
     */
    readonly attrEndpointConfigName: string;
    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     * @external
     */
    productionVariants: Array<CfnEndpointConfig.ProductionVariantProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
     * @external
     */
    dataCaptureConfig: CfnEndpointConfig.DataCaptureConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     * @external
     */
    endpointConfigName: string | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::EndpointConfig`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEndpointConfigProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 */
export declare namespace CfnEndpointConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html
     * @external
     */
    interface CaptureContentTypeHeaderProperty {
        /**
         * `CfnEndpointConfig.CaptureContentTypeHeaderProperty.CsvContentTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-csvcontenttypes
         * @external
         */
        readonly csvContentTypes?: string[];
        /**
         * `CfnEndpointConfig.CaptureContentTypeHeaderProperty.JsonContentTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-jsoncontenttypes
         * @external
         */
        readonly jsonContentTypes?: string[];
    }
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 */
export declare namespace CfnEndpointConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html
     * @external
     */
    interface CaptureOptionProperty {
        /**
         * `CfnEndpointConfig.CaptureOptionProperty.CaptureMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html#cfn-sagemaker-endpointconfig-captureoption-capturemode
         * @external
         */
        readonly captureMode: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 */
export declare namespace CfnEndpointConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html
     * @external
     */
    interface DataCaptureConfigProperty {
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.CaptureContentTypeHeader`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader
         * @external
         */
        readonly captureContentTypeHeader?: CfnEndpointConfig.CaptureContentTypeHeaderProperty | cdk.IResolvable;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.CaptureOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-captureoptions
         * @external
         */
        readonly captureOptions: Array<CfnEndpointConfig.CaptureOptionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.DestinationS3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-destinations3uri
         * @external
         */
        readonly destinationS3Uri: string;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.EnableCapture`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-enablecapture
         * @external
         */
        readonly enableCapture?: boolean | cdk.IResolvable;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.InitialSamplingPercentage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-initialsamplingpercentage
         * @external
         */
        readonly initialSamplingPercentage: number;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 */
export declare namespace CfnEndpointConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html
     * @external
     */
    interface ProductionVariantProperty {
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.AcceleratorType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype
         * @external
         */
        readonly acceleratorType?: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialInstanceCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
         * @external
         */
        readonly initialInstanceCount: number;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialVariantWeight`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
         * @external
         */
        readonly initialVariantWeight: number;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
         * @external
         */
        readonly instanceType: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.ModelName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
         * @external
         */
        readonly modelName: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.VariantName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
         * @external
         */
        readonly variantName: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 * @external
 */
export interface CfnModelProps {
    /**
     * `AWS::SageMaker::Model.ExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-executionrolearn
     * @external
     */
    readonly executionRoleArn: string;
    /**
     * `AWS::SageMaker::Model.Containers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-containers
     * @external
     */
    readonly containers?: Array<CfnModel.ContainerDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.EnableNetworkIsolation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-enablenetworkisolation
     * @external
     */
    readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.ModelName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-modelname
     * @external
     */
    readonly modelName?: string;
    /**
     * `AWS::SageMaker::Model.PrimaryContainer`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-primarycontainer
     * @external
     */
    readonly primaryContainer?: CfnModel.ContainerDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::Model.VpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-vpcconfig
     * @external
     */
    readonly vpcConfig?: CfnModel.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 */
export declare class CfnModel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Model";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnModel;
    /**
     * @external
     * @cloudformationAttribute ModelName
     */
    readonly attrModelName: string;
    /**
     * `AWS::SageMaker::Model.ExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-executionrolearn
     * @external
     */
    executionRoleArn: string;
    /**
     * `AWS::SageMaker::Model.Containers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-containers
     * @external
     */
    containers: Array<CfnModel.ContainerDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.EnableNetworkIsolation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-enablenetworkisolation
     * @external
     */
    enableNetworkIsolation: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.ModelName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-modelname
     * @external
     */
    modelName: string | undefined;
    /**
     * `AWS::SageMaker::Model.PrimaryContainer`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-primarycontainer
     * @external
     */
    primaryContainer: CfnModel.ContainerDefinitionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::Model.VpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-vpcconfig
     * @external
     */
    vpcConfig: CfnModel.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SageMaker::Model`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 */
export declare namespace CfnModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html
     * @external
     */
    interface ContainerDefinitionProperty {
        /**
         * `CfnModel.ContainerDefinitionProperty.ContainerHostname`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
         * @external
         */
        readonly containerHostname?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.Environment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
         * @external
         */
        readonly environment?: any | cdk.IResolvable;
        /**
         * `CfnModel.ContainerDefinitionProperty.Image`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
         * @external
         */
        readonly image?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.Mode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-mode
         * @external
         */
        readonly mode?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.ModelDataUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
         * @external
         */
        readonly modelDataUrl?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.ModelPackageName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modelpackagename
         * @external
         */
        readonly modelPackageName?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 */
export declare namespace CfnModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html
     * @external
     */
    interface VpcConfigProperty {
        /**
         * `CfnModel.VpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnModel.VpcConfigProperty.Subnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
         * @external
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 */
export interface CfnMonitoringScheduleProps {
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig
     * @external
     */
    readonly monitoringScheduleConfig: CfnMonitoringSchedule.MonitoringScheduleConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename
     * @external
     */
    readonly monitoringScheduleName: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.CreationTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-creationtime
     * @external
     */
    readonly creationTime?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.EndpointName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname
     * @external
     */
    readonly endpointName?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.FailureReason`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason
     * @external
     */
    readonly failureReason?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.LastModifiedTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmodifiedtime
     * @external
     */
    readonly lastModifiedTime?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary
     * @external
     */
    readonly lastMonitoringExecutionSummary?: CfnMonitoringSchedule.MonitoringExecutionSummaryProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulearn
     * @external
     */
    readonly monitoringScheduleArn?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleStatus`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus
     * @external
     */
    readonly monitoringScheduleStatus?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare class CfnMonitoringSchedule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::MonitoringSchedule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMonitoringSchedule;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig
     * @external
     */
    monitoringScheduleConfig: CfnMonitoringSchedule.MonitoringScheduleConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename
     * @external
     */
    monitoringScheduleName: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.CreationTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-creationtime
     * @external
     */
    creationTime: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.EndpointName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname
     * @external
     */
    endpointName: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.FailureReason`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason
     * @external
     */
    failureReason: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.LastModifiedTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmodifiedtime
     * @external
     */
    lastModifiedTime: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary
     * @external
     */
    lastMonitoringExecutionSummary: CfnMonitoringSchedule.MonitoringExecutionSummaryProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulearn
     * @external
     */
    monitoringScheduleArn: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleStatus`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus
     * @external
     */
    monitoringScheduleStatus: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::MonitoringSchedule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMonitoringScheduleProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html
     * @external
     */
    interface BaselineConfigProperty {
        /**
         * `CfnMonitoringSchedule.BaselineConfigProperty.ConstraintsResource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-constraintsresource
         * @external
         */
        readonly constraintsResource?: CfnMonitoringSchedule.ConstraintsResourceProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.BaselineConfigProperty.StatisticsResource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-statisticsresource
         * @external
         */
        readonly statisticsResource?: CfnMonitoringSchedule.StatisticsResourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html
     * @external
     */
    interface ClusterConfigProperty {
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.InstanceCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancecount
         * @external
         */
        readonly instanceCount: number;
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancetype
         * @external
         */
        readonly instanceType: string;
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.VolumeKmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumekmskeyid
         * @external
         */
        readonly volumeKmsKeyId?: string;
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.VolumeSizeInGB`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumesizeingb
         * @external
         */
        readonly volumeSizeInGb: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html
     * @external
     */
    interface ConstraintsResourceProperty {
        /**
         * `CfnMonitoringSchedule.ConstraintsResourceProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html#cfn-sagemaker-monitoringschedule-constraintsresource-s3uri
         * @external
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html
     * @external
     */
    interface EndpointInputProperty {
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.EndpointName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-endpointname
         * @external
         */
        readonly endpointName: string;
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.LocalPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-localpath
         * @external
         */
        readonly localPath: string;
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.S3DataDistributionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3datadistributiontype
         * @external
         */
        readonly s3DataDistributionType?: string;
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.S3InputMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3inputmode
         * @external
         */
        readonly s3InputMode?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-environment.html
     * @external
     */
    interface EnvironmentProperty {
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html
     * @external
     */
    interface MonitoringAppSpecificationProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ContainerArguments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerarguments
         * @external
         */
        readonly containerArguments?: string[];
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ContainerEntrypoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerentrypoint
         * @external
         */
        readonly containerEntrypoint?: string[];
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ImageUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-imageuri
         * @external
         */
        readonly imageUri: string;
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.PostAnalyticsProcessorSourceUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-postanalyticsprocessorsourceuri
         * @external
         */
        readonly postAnalyticsProcessorSourceUri?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.RecordPreprocessorSourceUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-recordpreprocessorsourceuri
         * @external
         */
        readonly recordPreprocessorSourceUri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html
     * @external
     */
    interface MonitoringExecutionSummaryProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.CreationTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-creationtime
         * @external
         */
        readonly creationTime: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.EndpointName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-endpointname
         * @external
         */
        readonly endpointName?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.FailureReason`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-failurereason
         * @external
         */
        readonly failureReason?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.LastModifiedTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-lastmodifiedtime
         * @external
         */
        readonly lastModifiedTime: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.MonitoringExecutionStatus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringexecutionstatus
         * @external
         */
        readonly monitoringExecutionStatus: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.MonitoringScheduleName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringschedulename
         * @external
         */
        readonly monitoringScheduleName: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.ProcessingJobArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-processingjobarn
         * @external
         */
        readonly processingJobArn?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.ScheduledTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-scheduledtime
         * @external
         */
        readonly scheduledTime: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html
     * @external
     */
    interface MonitoringInputProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringInputProperty.EndpointInput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html#cfn-sagemaker-monitoringschedule-monitoringinput-endpointinput
         * @external
         */
        readonly endpointInput: CfnMonitoringSchedule.EndpointInputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinputs.html
     * @external
     */
    interface MonitoringInputsProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringInputsProperty.MonitoringInputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinputs.html#cfn-sagemaker-monitoringschedule-monitoringinputs-monitoringinputs
         * @external
         */
        readonly monitoringInputs?: Array<CfnMonitoringSchedule.MonitoringInputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html
     * @external
     */
    interface MonitoringJobDefinitionProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.BaselineConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-baselineconfig
         * @external
         */
        readonly baselineConfig?: CfnMonitoringSchedule.BaselineConfigProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.Environment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-environment
         * @external
         */
        readonly environment?: CfnMonitoringSchedule.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringAppSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringappspecification
         * @external
         */
        readonly monitoringAppSpecification: CfnMonitoringSchedule.MonitoringAppSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringInputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringinputs
         * @external
         */
        readonly monitoringInputs: CfnMonitoringSchedule.MonitoringInputsProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringOutputConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringoutputconfig
         * @external
         */
        readonly monitoringOutputConfig: CfnMonitoringSchedule.MonitoringOutputConfigProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringResources`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringresources
         * @external
         */
        readonly monitoringResources: CfnMonitoringSchedule.MonitoringResourcesProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.NetworkConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-networkconfig
         * @external
         */
        readonly networkConfig?: CfnMonitoringSchedule.NetworkConfigProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.StoppingCondition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-stoppingcondition
         * @external
         */
        readonly stoppingCondition?: CfnMonitoringSchedule.StoppingConditionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html
     * @external
     */
    interface MonitoringOutputProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringOutputProperty.S3Output`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html#cfn-sagemaker-monitoringschedule-monitoringoutput-s3output
         * @external
         */
        readonly s3Output: CfnMonitoringSchedule.S3OutputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html
     * @external
     */
    interface MonitoringOutputConfigProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringOutputConfigProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringOutputConfigProperty.MonitoringOutputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-monitoringoutputs
         * @external
         */
        readonly monitoringOutputs: Array<CfnMonitoringSchedule.MonitoringOutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html
     * @external
     */
    interface MonitoringResourcesProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringResourcesProperty.ClusterConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html#cfn-sagemaker-monitoringschedule-monitoringresources-clusterconfig
         * @external
         */
        readonly clusterConfig: CfnMonitoringSchedule.ClusterConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html
     * @external
     */
    interface MonitoringScheduleConfigProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.MonitoringJobDefinition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringjobdefinition
         * @external
         */
        readonly monitoringJobDefinition: CfnMonitoringSchedule.MonitoringJobDefinitionProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.ScheduleConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-scheduleconfig
         * @external
         */
        readonly scheduleConfig?: CfnMonitoringSchedule.ScheduleConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html
     * @external
     */
    interface NetworkConfigProperty {
        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enableintercontainertrafficencryption
         * @external
         */
        readonly enableInterContainerTrafficEncryption?: boolean | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.EnableNetworkIsolation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enablenetworkisolation
         * @external
         */
        readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.VpcConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-vpcconfig
         * @external
         */
        readonly vpcConfig?: CfnMonitoringSchedule.VpcConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html
     * @external
     */
    interface S3OutputProperty {
        /**
         * `CfnMonitoringSchedule.S3OutputProperty.LocalPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-localpath
         * @external
         */
        readonly localPath: string;
        /**
         * `CfnMonitoringSchedule.S3OutputProperty.S3UploadMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uploadmode
         * @external
         */
        readonly s3UploadMode?: string;
        /**
         * `CfnMonitoringSchedule.S3OutputProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uri
         * @external
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html
     * @external
     */
    interface ScheduleConfigProperty {
        /**
         * `CfnMonitoringSchedule.ScheduleConfigProperty.ScheduleExpression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html#cfn-sagemaker-monitoringschedule-scheduleconfig-scheduleexpression
         * @external
         */
        readonly scheduleExpression: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html
     * @external
     */
    interface StatisticsResourceProperty {
        /**
         * `CfnMonitoringSchedule.StatisticsResourceProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html#cfn-sagemaker-monitoringschedule-statisticsresource-s3uri
         * @external
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html
     * @external
     */
    interface StoppingConditionProperty {
        /**
         * `CfnMonitoringSchedule.StoppingConditionProperty.MaxRuntimeInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html#cfn-sagemaker-monitoringschedule-stoppingcondition-maxruntimeinseconds
         * @external
         */
        readonly maxRuntimeInSeconds: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html
     * @external
     */
    interface VpcConfigProperty {
        /**
         * `CfnMonitoringSchedule.VpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnMonitoringSchedule.VpcConfigProperty.Subnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-subnets
         * @external
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::NotebookInstance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html
 * @external
 */
export interface CfnNotebookInstanceProps {
    /**
     * `AWS::SageMaker::NotebookInstance.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype
     * @external
     */
    readonly instanceType: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::NotebookInstance.AcceleratorTypes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-acceleratortypes
     * @external
     */
    readonly acceleratorTypes?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.AdditionalCodeRepositories`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-additionalcoderepositories
     * @external
     */
    readonly additionalCodeRepositories?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.DefaultCodeRepository`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-defaultcoderepository
     * @external
     */
    readonly defaultCodeRepository?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.DirectInternetAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess
     * @external
     */
    readonly directInternetAccess?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.LifecycleConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname
     * @external
     */
    readonly lifecycleConfigName?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.NotebookInstanceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename
     * @external
     */
    readonly notebookInstanceName?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RootAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess
     * @external
     */
    readonly rootAccess?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids
     * @external
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid
     * @external
     */
    readonly subnetId?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb
     * @external
     */
    readonly volumeSizeInGb?: number;
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html
 * @external
 * @cloudformationResource AWS::SageMaker::NotebookInstance
 */
export declare class CfnNotebookInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::NotebookInstance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNotebookInstance;
    /**
     * @external
     * @cloudformationAttribute NotebookInstanceName
     */
    readonly attrNotebookInstanceName: string;
    /**
     * `AWS::SageMaker::NotebookInstance.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype
     * @external
     */
    instanceType: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::NotebookInstance.AcceleratorTypes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-acceleratortypes
     * @external
     */
    acceleratorTypes: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.AdditionalCodeRepositories`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-additionalcoderepositories
     * @external
     */
    additionalCodeRepositories: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.DefaultCodeRepository`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-defaultcoderepository
     * @external
     */
    defaultCodeRepository: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.DirectInternetAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess
     * @external
     */
    directInternetAccess: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.LifecycleConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname
     * @external
     */
    lifecycleConfigName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.NotebookInstanceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename
     * @external
     */
    notebookInstanceName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.RootAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess
     * @external
     */
    rootAccess: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids
     * @external
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid
     * @external
     */
    subnetId: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb
     * @external
     */
    volumeSizeInGb: number | undefined;
    /**
     * Create a new `AWS::SageMaker::NotebookInstance`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNotebookInstanceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 * @external
 */
export interface CfnNotebookInstanceLifecycleConfigProps {
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.NotebookInstanceLifecycleConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecycleconfigname
     * @external
     */
    readonly notebookInstanceLifecycleConfigName?: string;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnCreate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-oncreate
     * @external
     */
    readonly onCreate?: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnStart`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-onstart
     * @external
     */
    readonly onStart?: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::NotebookInstanceLifecycleConfig
 */
export declare class CfnNotebookInstanceLifecycleConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::NotebookInstanceLifecycleConfig";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNotebookInstanceLifecycleConfig;
    /**
     * @external
     * @cloudformationAttribute NotebookInstanceLifecycleConfigName
     */
    readonly attrNotebookInstanceLifecycleConfigName: string;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.NotebookInstanceLifecycleConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecycleconfigname
     * @external
     */
    notebookInstanceLifecycleConfigName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnCreate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-oncreate
     * @external
     */
    onCreate: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnStart`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-onstart
     * @external
     */
    onStart: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnNotebookInstanceLifecycleConfigProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::NotebookInstanceLifecycleConfig
 */
export declare namespace CfnNotebookInstanceLifecycleConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook.html
     * @external
     */
    interface NotebookInstanceLifecycleHookProperty {
        /**
         * `CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty.Content`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook-content
         * @external
         */
        readonly content?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Workteam`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 * @external
 */
export interface CfnWorkteamProps {
    /**
     * `AWS::SageMaker::Workteam.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::SageMaker::Workteam.MemberDefinitions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions
     * @external
     */
    readonly memberDefinitions?: Array<CfnWorkteam.MemberDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Workteam.NotificationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration
     * @external
     */
    readonly notificationConfiguration?: CfnWorkteam.NotificationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Workteam.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::Workteam.WorkteamName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname
     * @external
     */
    readonly workteamName?: string;
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 * @external
 * @cloudformationResource AWS::SageMaker::Workteam
 */
export declare class CfnWorkteam extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Workteam";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWorkteam;
    /**
     * @external
     * @cloudformationAttribute WorkteamName
     */
    readonly attrWorkteamName: string;
    /**
     * `AWS::SageMaker::Workteam.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::SageMaker::Workteam.MemberDefinitions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions
     * @external
     */
    memberDefinitions: Array<CfnWorkteam.MemberDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Workteam.NotificationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration
     * @external
     */
    notificationConfiguration: CfnWorkteam.NotificationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Workteam.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::Workteam.WorkteamName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname
     * @external
     */
    workteamName: string | undefined;
    /**
     * Create a new `AWS::SageMaker::Workteam`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnWorkteamProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 * @external
 * @cloudformationResource AWS::SageMaker::Workteam
 */
export declare namespace CfnWorkteam {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html
     * @external
     */
    interface CognitoMemberDefinitionProperty {
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoClientId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitoclientid
         * @external
         */
        readonly cognitoClientId: string;
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitousergroup
         * @external
         */
        readonly cognitoUserGroup: string;
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserPool`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitouserpool
         * @external
         */
        readonly cognitoUserPool: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 * @external
 * @cloudformationResource AWS::SageMaker::Workteam
 */
export declare namespace CfnWorkteam {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-memberdefinition.html
     * @external
     */
    interface MemberDefinitionProperty {
        /**
         * `CfnWorkteam.MemberDefinitionProperty.CognitoMemberDefinition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-memberdefinition.html#cfn-sagemaker-workteam-memberdefinition-cognitomemberdefinition
         * @external
         */
        readonly cognitoMemberDefinition: CfnWorkteam.CognitoMemberDefinitionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 * @external
 * @cloudformationResource AWS::SageMaker::Workteam
 */
export declare namespace CfnWorkteam {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-notificationconfiguration.html
     * @external
     */
    interface NotificationConfigurationProperty {
        /**
         * `CfnWorkteam.NotificationConfigurationProperty.NotificationTopicArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-notificationconfiguration.html#cfn-sagemaker-workteam-notificationconfiguration-notificationtopicarn
         * @external
         */
        readonly notificationTopicArn: string;
    }
}
