import { Duration } from "../../core";
/**
 * (experimental) Declaration of a Life cycle rule.
 *
 * @experimental
 */
export interface LifecycleRule {
    /**
     * (experimental) A unique identifier for this rule.
     *
     * The value cannot be more than 255 characters.
     *
     * @experimental
     */
    readonly id?: string;
    /**
     * (experimental) Whether this rule is enabled.
     *
     * @default true
     * @experimental
     */
    readonly enabled?: boolean;
    /**
     * (experimental) Specifies a lifecycle rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     *
     * The AbortIncompleteMultipartUpload property type creates a lifecycle
     * rule that aborts incomplete multipart uploads to an Amazon S3 bucket.
     * When Amazon S3 aborts a multipart upload, it deletes all parts
     * associated with the multipart upload.
     *
     * @default Incomplete uploads are never aborted
     * @experimental
     */
    readonly abortIncompleteMultipartUploadAfter?: Duration;
    /**
     * (experimental) Indicates when objects are deleted from Amazon S3 and Amazon Glacier.
     *
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     *
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     *
     * @default No expiration date
     * @experimental
     */
    readonly expirationDate?: Date;
    /**
     * (experimental) Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon Glacier.
     *
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     *
     * @default No expiration timeout
     * @experimental
     */
    readonly expiration?: Duration;
    /**
     * (experimental) Time between when a new version of the object is uploaded to the bucket and when old versions of the object expire.
     *
     * For buckets with versioning enabled (or suspended), specifies the time,
     * in days, between when a new version of the object is uploaded to the
     * bucket and when old versions of the object expire. When object versions
     * expire, Amazon S3 permanently deletes them. If you specify a transition
     * and expiration time, the expiration time must be later than the
     * transition time.
     *
     * @default No noncurrent version expiration
     * @experimental
     */
    readonly noncurrentVersionExpiration?: Duration;
    /**
     * (experimental) One or more transition rules that specify when non-current objects transition to a specified storage class.
     *
     * Only for for buckets with versioning enabled (or suspended).
     *
     * If you specify a transition and expiration time, the expiration time
     * must be later than the transition time.
     *
     * @experimental
     */
    readonly noncurrentVersionTransitions?: NoncurrentVersionTransition[];
    /**
     * (experimental) One or more transition rules that specify when an object transitions to a specified storage class.
     *
     * If you specify an expiration and transition time, you must use the same
     * time unit for both properties (either in days or by date). The
     * expiration time must also be later than the transition time.
     *
     * @default No transition rules
     * @experimental
     */
    readonly transitions?: Transition[];
    /**
     * (experimental) Object key prefix that identifies one or more objects to which this rule applies.
     *
     * @default Rule applies to all objects
     * @experimental
     */
    readonly prefix?: string;
    /**
     * (experimental) The TagFilter property type specifies tags to use to identify a subset of objects for an Amazon S3 bucket.
     *
     * @default Rule applies to all objects
     * @experimental
     */
    readonly tagFilters?: {
        [tag: string]: any;
    };
}
/**
 * (experimental) Describes when an object transitions to a specified storage class.
 *
 * @experimental
 */
export interface Transition {
    /**
     * (experimental) The storage class to which you want the object to transition.
     *
     * @experimental
     */
    readonly storageClass: StorageClass;
    /**
     * (experimental) Indicates when objects are transitioned to the specified storage class.
     *
     * The date value must be in ISO 8601 format. The time is always midnight UTC.
     *
     * @default No transition date.
     * @experimental
     */
    readonly transitionDate?: Date;
    /**
     * (experimental) Indicates the number of days after creation when objects are transitioned to the specified storage class.
     *
     * @default No transition count.
     * @experimental
     */
    readonly transitionAfter?: Duration;
}
/**
 * (experimental) Describes when noncurrent versions transition to a specified storage class.
 *
 * @experimental
 */
export interface NoncurrentVersionTransition {
    /**
     * (experimental) The storage class to which you want the object to transition.
     *
     * @experimental
     */
    readonly storageClass: StorageClass;
    /**
     * (experimental) Indicates the number of days after creation when objects are transitioned to the specified storage class.
     *
     * @default No transition count.
     * @experimental
     */
    readonly transitionAfter: Duration;
}
/**
 * (experimental) Storage class to move an object to.
 *
 * @experimental
 */
export declare class StorageClass {
    readonly value: string;
    /**
     * (experimental) Storage class for data that is accessed less frequently, but requires rapid access when needed.
     *
     * Has lower availability than Standard storage.
     *
     * @experimental
     */
    static readonly INFREQUENT_ACCESS: StorageClass;
    /**
     * (experimental) Infrequent Access that's only stored in one availability zone.
     *
     * Has lower availability than standard InfrequentAccess.
     *
     * @experimental
     */
    static readonly ONE_ZONE_INFREQUENT_ACCESS: StorageClass;
    /**
     * (experimental) Storage class for long-term archival that can take between minutes and hours to access.
     *
     * Use for archives where portions of the data might need to be retrieved in
     * minutes. Data stored in the GLACIER storage class has a minimum storage
     * duration period of 90 days and can be accessed in as little as 1-5 minutes
     * using expedited retrieval. If you delete an object before the 90-day
     * minimum, you are charged for 90 days.
     *
     * @experimental
     */
    static readonly GLACIER: StorageClass;
    /**
     * (experimental) Use for archiving data that rarely needs to be accessed.
     *
     * Data stored in the
     * DEEP_ARCHIVE storage class has a minimum storage duration period of 180
     * days and a default retrieval time of 12 hours. If you delete an object
     * before the 180-day minimum, you are charged for 180 days. For pricing
     * information, see Amazon S3 Pricing.
     *
     * @experimental
     */
    static readonly DEEP_ARCHIVE: StorageClass;
    /**
     * (experimental) The INTELLIGENT_TIERING storage class is designed to optimize storage costs by automatically moving data to the most cost-effective storage access tier, without performance impact or operational overhead.
     *
     * INTELLIGENT_TIERING delivers automatic cost savings by moving data on a
     * granular object level between two access tiers, a frequent access tier and
     * a lower-cost infrequent access tier, when access patterns change. The
     * INTELLIGENT_TIERING storage class is ideal if you want to optimize storage
     * costs automatically for long-lived data when access patterns are unknown or
     * unpredictable.
     *
     * @experimental
     */
    static readonly INTELLIGENT_TIERING: StorageClass;
    /**
     * @experimental
     */
    constructor(value: string);
    /**
     * @experimental
     */
    toString(): string;
}
